/*
 * Decompiled with CFR 0.152.
 */
package cn.openx.boot.framework.booster.web.result;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.openx.boot.framework.booster.web.code.BaseCode;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.beans.Transient;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"code", "message", "data"})
public abstract class ApiCoreResult<E> {
    private static final Logger log = LoggerFactory.getLogger(ApiCoreResult.class);
    @ApiModelProperty(value="\u4e1a\u52a1\u54cd\u5e94\u7801=200 \u6210\u529f")
    @NonNull
    protected String code;
    @ApiModelProperty(value="\u54cd\u5e94\u7801\u7684\u5177\u4f53\u8bf4\u660e\u4fe1\u606f")
    @NonNull
    protected String message;
    @ApiModelProperty(value="\u4e1a\u52a1\u6570\u636e")
    protected E data;

    @Transient
    protected BaseCode[] getOkCodes() {
        return new BaseCode[]{BaseCode.SUCCESS};
    }

    public E getData() {
        if (this.data instanceof Exception) {
            try {
                Throwable exceptionData = (Throwable)this.data;
                String stackTraceContent = StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{"\n message:", ExceptionUtil.getMessage((Throwable)exceptionData), "\n stacktrace:", ExceptionUtil.stacktraceToString((Throwable)exceptionData)});
                this.data = stackTraceContent;
            }
            catch (Exception e) {
                log.error("\u5c06\u5f02\u5e38\u5806\u6808\u8fdb\u884c\u683c\u5f0f\u5316\u8f93\u51fa\uff0c\u53d1\u751f\u5f02\u5e38 {} ", (Throwable)e);
            }
        }
        return (E)this.data;
    }

    @Transient
    public boolean isSuccess() {
        return Stream.of(this.getOkCodes()).anyMatch(respOKCode -> Objects.equals(this.code, respOKCode.getCode()));
    }

    @Transient
    public boolean isError() {
        return !this.isSuccess();
    }

    @NonNull
    public String getCode() {
        return this.code;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    public void setCode(@NonNull String code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        this.code = code;
    }

    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
    }

    public void setData(E data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiCoreResult)) {
            return false;
        }
        ApiCoreResult other = (ApiCoreResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiCoreResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ApiCoreResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public ApiCoreResult(@NonNull String code, @NonNull String message, E data) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public ApiCoreResult() {
    }
}

