/*
 * Decompiled with CFR 0.152.
 */
package cn.openx.boot.framework.booster.util.redis;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.stereotype.Component;

@Component
public class RedisUtils {
    private static final byte[] SCRIPT_RELEASE_LOCK = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end".getBytes();
    private static StringRedisTemplate redisTemplate;
    @Autowired
    private ApplicationContext applicationContext;
    public static RedisUtils redisUtils;

    @PostConstruct
    public void init() {
        redisUtils = this;
        redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
    }

    public StringRedisTemplate getRedisTemplate() {
        return redisTemplate;
    }

    public static Boolean tryLock(String lockKey, String clientId, long seconds) {
        return (Boolean)redisTemplate.execute(redisConnection -> {
            Boolean result = redisConnection.set(lockKey.getBytes(), clientId.getBytes(), Expiration.from((long)seconds, (TimeUnit)TimeUnit.SECONDS), RedisStringCommands.SetOption.SET_IF_ABSENT);
            return result;
        });
    }

    public static Boolean releaseLock(String lockKey, String clientId) {
        return (Boolean)redisTemplate.execute(redisConnection -> {
            Boolean result = (Boolean)redisConnection.eval(SCRIPT_RELEASE_LOCK, ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{lockKey.getBytes(), clientId.getBytes()});
            return result;
        });
    }

    public static void delete(String key) {
        redisTemplate.delete((Object)key);
    }

    public static void delete(Collection<String> keys) {
        redisTemplate.delete(keys);
    }

    public static byte[] dump(String key) {
        return redisTemplate.dump((Object)key);
    }

    public static Boolean hasKey(String key) {
        return redisTemplate.hasKey((Object)key);
    }

    public static Boolean expire(String key, long timeout, TimeUnit unit) {
        return redisTemplate.expire((Object)key, timeout, unit);
    }

    public static Boolean expireAt(String key, Date date) {
        return redisTemplate.expireAt((Object)key, date);
    }

    public static Set<String> keys(String pattern) {
        return redisTemplate.keys((Object)pattern);
    }

    public static Boolean move(String key, int dbIndex) {
        return redisTemplate.move((Object)key, dbIndex);
    }

    public static Boolean persist(String key) {
        return redisTemplate.persist((Object)key);
    }

    public static Long getExpire(String key, TimeUnit unit) {
        return redisTemplate.getExpire((Object)key, unit);
    }

    public static Long getExpire(String key) {
        return redisTemplate.getExpire((Object)key);
    }

    public static String randomKey() {
        return (String)redisTemplate.randomKey();
    }

    public static void rename(String oldKey, String newKey) {
        redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public static Boolean renameIfAbsent(String oldKey, String newKey) {
        return redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public static DataType type(String key) {
        return redisTemplate.type((Object)key);
    }

    public static void set(String key, String value) {
        redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public static String get(String key) {
        return (String)redisTemplate.opsForValue().get((Object)key);
    }

    public static String getRange(String key, long start, long end) {
        return redisTemplate.opsForValue().get((Object)key, start, end);
    }

    public static String getAndSet(String key, String value) {
        return (String)redisTemplate.opsForValue().getAndSet((Object)key, (Object)value);
    }

    public static Boolean getBit(String key, long offset) {
        return redisTemplate.opsForValue().getBit((Object)key, offset);
    }

    public static List<String> multiGet(Collection<String> keys) {
        return redisTemplate.opsForValue().multiGet(keys);
    }

    public static boolean setBit(String key, long offset, boolean value) {
        return redisTemplate.opsForValue().setBit((Object)key, offset, value);
    }

    public static void setEx(String key, String value, long timeout, TimeUnit unit) {
        redisTemplate.opsForValue().set((Object)key, (Object)value, timeout, unit);
    }

    public static boolean setIfAbsent(String key, String value) {
        return redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public static void setRange(String key, String value, long offset) {
        redisTemplate.opsForValue().set((Object)key, (Object)value, offset);
    }

    public static Long size(String key) {
        return redisTemplate.opsForValue().size((Object)key);
    }

    public static void multiSet(Map<String, String> maps) {
        redisTemplate.opsForValue().multiSet(maps);
    }

    public static boolean multiSetIfAbsent(Map<String, String> maps) {
        return redisTemplate.opsForValue().multiSetIfAbsent(maps);
    }

    public static Long incrBy(String key, long increment) {
        return redisTemplate.opsForValue().increment((Object)key, increment);
    }

    public static Double incrByFloat(String key, double increment) {
        return redisTemplate.opsForValue().increment((Object)key, increment);
    }

    public static Integer append(String key, String value) {
        return redisTemplate.opsForValue().append((Object)key, value);
    }

    public static Object hGet(String key, String field) {
        return redisTemplate.opsForHash().get((Object)key, (Object)field);
    }

    public static Map<Object, Object> hGetAll(String key) {
        return redisTemplate.opsForHash().entries((Object)key);
    }

    public static List<Object> hMultiGet(String key, Collection<Object> fields) {
        return redisTemplate.opsForHash().multiGet((Object)key, fields);
    }

    public static void hPut(String key, String hashKey, String value) {
        redisTemplate.opsForHash().put((Object)key, (Object)hashKey, (Object)value);
    }

    public static void hPutAll(String key, Map<String, String> maps) {
        redisTemplate.opsForHash().putAll((Object)key, maps);
    }

    public static Boolean hPutIfAbsent(String key, String hashKey, String value) {
        return redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)hashKey, (Object)value);
    }

    public static Long hDelete(String key, Object ... fields) {
        return redisTemplate.opsForHash().delete((Object)key, fields);
    }

    public static boolean hExists(String key, String field) {
        return redisTemplate.opsForHash().hasKey((Object)key, (Object)field);
    }

    public static Long hIncrBy(String key, Object field, long increment) {
        return redisTemplate.opsForHash().increment((Object)key, field, increment);
    }

    public static Double hIncrByFloat(String key, Object field, double delta) {
        return redisTemplate.opsForHash().increment((Object)key, field, delta);
    }

    public static Set<Object> hKeys(String key) {
        return redisTemplate.opsForHash().keys((Object)key);
    }

    public static Long hSize(String key) {
        return redisTemplate.opsForHash().size((Object)key);
    }

    public static List<Object> hValues(String key) {
        return redisTemplate.opsForHash().values((Object)key);
    }

    public static Cursor<Map.Entry<Object, Object>> hScan(String key, ScanOptions options) {
        return redisTemplate.opsForHash().scan((Object)key, options);
    }

    public static String lIndex(String key, long index) {
        return (String)redisTemplate.opsForList().index((Object)key, index);
    }

    public static List<String> lRange(String key, long start, long end) {
        return redisTemplate.opsForList().range((Object)key, start, end);
    }

    public static Long lLeftPush(String key, String value) {
        return redisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public static Long lLeftPushAll(String key, String ... value) {
        return redisTemplate.opsForList().leftPushAll((Object)key, (Object[])value);
    }

    public static Long lLeftPushAll(String key, Collection<String> value) {
        return redisTemplate.opsForList().leftPushAll((Object)key, value);
    }

    public static Long lLeftPushIfPresent(String key, String value) {
        return redisTemplate.opsForList().leftPushIfPresent((Object)key, (Object)value);
    }

    public static Long lLeftPush(String key, String pivot, String value) {
        return redisTemplate.opsForList().leftPush((Object)key, (Object)pivot, (Object)value);
    }

    public static Long lRightPush(String key, String value) {
        return redisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    public static Long lRightPushAll(String key, String ... value) {
        return redisTemplate.opsForList().rightPushAll((Object)key, (Object[])value);
    }

    public static Long lRightPushAll(String key, Collection<String> value) {
        return redisTemplate.opsForList().rightPushAll((Object)key, value);
    }

    public static Long lRightPushIfPresent(String key, String value) {
        return redisTemplate.opsForList().rightPushIfPresent((Object)key, (Object)value);
    }

    public static Long lRightPush(String key, String pivot, String value) {
        return redisTemplate.opsForList().rightPush((Object)key, (Object)pivot, (Object)value);
    }

    public static void lSet(String key, long index, String value) {
        redisTemplate.opsForList().set((Object)key, index, (Object)value);
    }

    public static String lLeftPop(String key) {
        return (String)redisTemplate.opsForList().leftPop((Object)key);
    }

    public static String lBLeftPop(String key, long timeout, TimeUnit unit) {
        return (String)redisTemplate.opsForList().leftPop((Object)key, timeout, unit);
    }

    public static String lRightPop(String key) {
        return (String)redisTemplate.opsForList().rightPop((Object)key);
    }

    public static String lBRightPop(String key, long timeout, TimeUnit unit) {
        return (String)redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
    }

    public static String lRightPopAndLeftPush(String sourceKey, String destinationKey) {
        return (String)redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
    }

    public static String lBRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
        return (String)redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
    }

    public static Long lRemove(String key, long index, String value) {
        return redisTemplate.opsForList().remove((Object)key, index, (Object)value);
    }

    public static void lTrim(String key, long start, long end) {
        redisTemplate.opsForList().trim((Object)key, start, end);
    }

    public static Long lLen(String key) {
        return redisTemplate.opsForList().size((Object)key);
    }

    public static Long sAdd(String key, String ... values) {
        return redisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    public static Long sRemove(String key, Object ... values) {
        return redisTemplate.opsForSet().remove((Object)key, values);
    }

    public static String sPop(String key) {
        return (String)redisTemplate.opsForSet().pop((Object)key);
    }

    public static Boolean sMove(String key, String value, String destKey) {
        return redisTemplate.opsForSet().move((Object)key, (Object)value, (Object)destKey);
    }

    public static Long sSize(String key) {
        return redisTemplate.opsForSet().size((Object)key);
    }

    public static Boolean sIsMember(String key, Object value) {
        return redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public static Set<String> sIntersect(String key, String otherKey) {
        return redisTemplate.opsForSet().intersect((Object)key, (Object)otherKey);
    }

    public static Set<String> sIntersect(String key, Collection<String> otherKeys) {
        return redisTemplate.opsForSet().intersect((Object)key, otherKeys);
    }

    public static Long sIntersectAndStore(String key, String otherKey, String destKey) {
        return redisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public static Long sIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisTemplate.opsForSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public static Set<String> sUnion(String key, String otherKeys) {
        return redisTemplate.opsForSet().union((Object)key, (Object)otherKeys);
    }

    public static Set<String> sUnion(String key, Collection<String> otherKeys) {
        return redisTemplate.opsForSet().union((Object)key, otherKeys);
    }

    public static Long sUnionAndStore(String key, String otherKey, String destKey) {
        return redisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public static Long sUnionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisTemplate.opsForSet().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public static Set<String> sDifference(String key, String otherKey) {
        return redisTemplate.opsForSet().difference((Object)key, (Object)otherKey);
    }

    public static Set<String> sDifference(String key, Collection<String> otherKeys) {
        return redisTemplate.opsForSet().difference((Object)key, otherKeys);
    }

    public static Long sDifference(String key, String otherKey, String destKey) {
        return redisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public static Long sDifference(String key, Collection<String> otherKeys, String destKey) {
        return redisTemplate.opsForSet().differenceAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public static Set<String> setMembers(String key) {
        return redisTemplate.opsForSet().members((Object)key);
    }

    public static String sRandomMember(String key) {
        return (String)redisTemplate.opsForSet().randomMember((Object)key);
    }

    public static List<String> sRandomMembers(String key, long count) {
        return redisTemplate.opsForSet().randomMembers((Object)key, count);
    }

    public static Set<String> sDistinctRandomMembers(String key, long count) {
        return redisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
    }

    public static Cursor<String> sScan(String key, ScanOptions options) {
        return redisTemplate.opsForSet().scan((Object)key, options);
    }

    public static Boolean zAdd(String key, String value, double score) {
        return redisTemplate.opsForZSet().add((Object)key, (Object)value, score);
    }

    public static Long zAdd(String key, Set<ZSetOperations.TypedTuple<String>> values) {
        return redisTemplate.opsForZSet().add((Object)key, values);
    }

    public static Long zRemove(String key, Object ... values) {
        return redisTemplate.opsForZSet().remove((Object)key, values);
    }

    public static Double zIncrementScore(String key, String value, double delta) {
        return redisTemplate.opsForZSet().incrementScore((Object)key, (Object)value, delta);
    }

    public static Long zRank(String key, Object value) {
        return redisTemplate.opsForZSet().rank((Object)key, value);
    }

    public static Long zReverseRank(String key, Object value) {
        return redisTemplate.opsForZSet().reverseRank((Object)key, value);
    }

    public static Set<String> zRange(String key, long start, long end) {
        return redisTemplate.opsForZSet().range((Object)key, start, end);
    }

    public static Set<ZSetOperations.TypedTuple<String>> zRangeWithScores(String key, long start, long end) {
        return redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
    }

    public static Set<String> zRangeByScore(String key, double min, double max) {
        return redisTemplate.opsForZSet().rangeByScore((Object)key, min, max);
    }

    public static Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double min, double max) {
        return redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max);
    }

    public static Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double min, double max, long start, long end) {
        return redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max, start, end);
    }

    public static Set<String> zReverseRange(String key, long start, long end) {
        return redisTemplate.opsForZSet().reverseRange((Object)key, start, end);
    }

    public static Set<ZSetOperations.TypedTuple<String>> zReverseRangeWithScores(String key, long start, long end) {
        return redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end);
    }

    public static Set<String> zReverseRangeByScore(String key, double min, double max) {
        return redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max);
    }

    public static Set<ZSetOperations.TypedTuple<String>> zReverseRangeByScoreWithScores(String key, double min, double max) {
        return redisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, min, max);
    }

    public static Set<String> zReverseRangeByScore(String key, double min, double max, long start, long end) {
        return redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max, start, end);
    }

    public static Long zCount(String key, double min, double max) {
        return redisTemplate.opsForZSet().count((Object)key, min, max);
    }

    public static Long zSize(String key) {
        return redisTemplate.opsForZSet().size((Object)key);
    }

    public static Long zZCard(String key) {
        return redisTemplate.opsForZSet().zCard((Object)key);
    }

    public static Double zScore(String key, Object value) {
        return redisTemplate.opsForZSet().score((Object)key, value);
    }

    public static Long zRemoveRange(String key, long start, long end) {
        return redisTemplate.opsForZSet().removeRange((Object)key, start, end);
    }

    public static Long zRemoveRangeByScore(String key, double min, double max) {
        return redisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
    }

    public static Long zUnionAndStore(String key, String otherKey, String destKey) {
        return redisTemplate.opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public static Long zUnionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisTemplate.opsForZSet().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public static Long zIntersectAndStore(String key, String otherKey, String destKey) {
        return redisTemplate.opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public static Long zIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public static Cursor<ZSetOperations.TypedTuple<String>> zScan(String key, ScanOptions options) {
        return redisTemplate.opsForZSet().scan((Object)key, options);
    }
}

