/*
 * Decompiled with CFR 0.152.
 */
package cn.openx.boot.framework.booster.util.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    private static final int[] days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String day = "d";
    public static final String week = "w";
    public static final String month = "m";
    public static final String year = "y";
    private static final ThreadLocal<DateFormat> DATETIME_FORMAT = new /* Unavailable Anonymous Inner Class!! */;
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new /* Unavailable Anonymous Inner Class!! */;
    private static final ThreadLocal<DateFormat> ACCULATE_TIME_FORMAT = new /* Unavailable Anonymous Inner Class!! */;

    private DateUtils() {
    }

    public static int getDate() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5);
    }

    public static int getTime() {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        return hour * 10000 + minute * 100 + second;
    }

    public static Date getNowTime() {
        return Calendar.getInstance().getTime();
    }

    public static Date getNowDate() {
        Calendar now = Calendar.getInstance();
        return new GregorianCalendar(now.get(1), now.get(2), now.get(5)).getTime();
    }

    public static Calendar addMonth(int monthCount) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, cal.get(2) + monthCount);
        return cal;
    }

    public static Calendar add(int type, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.set(type, cal.get(type) + amount);
        return cal;
    }

    public static Calendar addMonth(Date date, int monthCount) {
        Calendar cal = DateUtils.convertDateToCal((Date)date);
        cal.set(13, cal.get(2) + monthCount);
        return cal;
    }

    public static Date addDayByNow(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date addDay(Date date, String term) {
        return DateUtils.addDay((Date)date, (int)DateUtils.countDay((Date)date, (String)term));
    }

    public static int getDays(Date start, Date end) {
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(start);
        endCal.setTime(end);
        return (int)((endCal.getTime().getTime() - startCal.getTime().getTime()) / 86400000L);
    }

    public static String formatCalToStr(Calendar cal, String sformat) {
        DateFormat dateFormat = null;
        try {
            dateFormat = new SimpleDateFormat(sformat);
        }
        catch (IllegalArgumentException e) {
            dateFormat = (DateFormat)DATETIME_FORMAT.get();
        }
        return dateFormat.format(cal == null ? Calendar.getInstance().getTime() : cal.getTime());
    }

    public static String formatDateToStr(Date date, String format) {
        DateFormat sdf;
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = format == null ? (DateFormat)DATETIME_FORMAT.get() : (sdf = "yyyy-MM-dd".equals(format) ? (DateFormat)DATE_FORMAT.get() : new SimpleDateFormat(format));
        if ("CNS".equals(format)) {
            sdf = (DateFormat)DATE_FORMAT.get();
            String[] str = sdf.format(date).split("-");
            return str[0] + "\u5e74" + str[1] + "\u6708" + str[2] + "\u65e5";
        }
        return sdf.format(date);
    }

    public static Date formatStrToDate(String dateStr, String format) {
        if (dateStr == null || dateStr.length() == 0) {
            return null;
        }
        DateFormat sdf = format == null ? (DateFormat)DATETIME_FORMAT.get() : ("yyyy-MM-dd".equals(format) ? (DateFormat)DATE_FORMAT.get() : new SimpleDateFormat(format));
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAcculateTime(Date date) {
        if (date == null) {
            return "";
        }
        return ((DateFormat)ACCULATE_TIME_FORMAT.get()).format(date);
    }

    public static String getSimpleDate(Date date) {
        if (date == null) {
            return "";
        }
        return ((DateFormat)DATE_FORMAT.get()).format(date);
    }

    public static String getSimpleDate(String date) {
        return DateUtils.getSimpleDate((Date)DateUtils.formatStrToDate((String)date, (String)"yyyy-MM-dd"));
    }

    public static Calendar convertDateToCal(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static String getIntTimeToStr(int time) {
        int hour = time / 10000;
        int min = (time - hour * 10000) / 100;
        int sec = time - hour * 10000 - min * 100;
        String hours = hour + "";
        String mins = min + "";
        String secs = sec + "";
        if (0 <= hour && hour <= 9) {
            hours = "0" + hour;
        }
        if (0 <= min && min <= 9) {
            mins = "0" + min;
        }
        if (0 <= sec && sec <= 9) {
            secs = "0" + sec;
        }
        return hours + ":" + mins + ":" + secs;
    }

    public int addValidDate(int years, int months, int days) {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar validDate = new GregorianCalendar(now.get(1), now.get(2) + 1, now.get(5));
        String year = String.valueOf(validDate.get(1) + years);
        String month = String.valueOf(validDate.get(2) + months);
        String day = String.valueOf(validDate.get(5) + days);
        if (month.length() < 2) {
            month = "0" + month;
        }
        if (day.length() < 2) {
            day = "0" + day;
        }
        String nowDate = year + month + day;
        return Integer.parseInt(nowDate);
    }

    public static int countDay(Date startDate, String term) {
        if (term == null || term.trim().length() == 0) {
            return 0;
        }
        String str = term.trim().toLowerCase();
        int result = 0;
        char cha = str.charAt(str.length() - 1);
        if ('/' < cha && cha < ':') {
            str = str + "d";
        }
        if (str.length() == 1) {
            str = "0" + str;
        }
        try {
            result = Integer.parseInt(str.substring(0, str.length() - 1));
        }
        catch (Exception e) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int days = 0;
        if (str.endsWith("d")) {
            days = result;
        } else if (str.endsWith("w")) {
            days = result * 7;
        } else if (str.endsWith("m")) {
            cal.add(2, result);
            days = DateUtils.getDays((Date)startDate, (Date)cal.getTime());
        } else if (str.endsWith("y")) {
            cal.add(1, result);
            days = DateUtils.getDays((Date)startDate, (Date)cal.getTime());
        } else {
            days = 0;
        }
        return days;
    }

    public static int countDay(String startDate, String term) throws Exception {
        Date date = ((DateFormat)DATE_FORMAT.get()).parse(startDate);
        return DateUtils.countDay((Date)date, (String)term);
    }

    public static int compareTime(Date date1, Date date2) {
        long intDate2;
        long intDate1 = date1.getTime();
        return intDate1 >= (intDate2 = date2.getTime()) ? (intDate1 == intDate2 ? 0 : 1) : -1;
    }

    public static int compareTime(String date1, String date2) throws ParseException {
        long intDate2;
        long intDate1 = DateUtils.formatStrToDate((String)date1, null).getTime();
        return intDate1 >= (intDate2 = DateUtils.formatStrToDate((String)date2, null).getTime()) ? (intDate1 == intDate2 ? 0 : 1) : -1;
    }

    public static int yearsOf(Date start, Date end) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(start);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(end);
        return c2.get(1) - c1.get(1) + 1;
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.roll(5, -1);
        return cal.getTime();
    }

    public static String getChineseWeek(String date, String format) {
        String[] day = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
        return "\u661f\u671f" + day[DateUtils.getWeek((String)date, (String)format)];
    }

    public static Integer getWeek(String date, String format) {
        format = format == null ? "yyyy-MM-dd HH:mm:ss" : format;
        Calendar cal = DateUtils.convertDateToCal((Date)DateUtils.formatStrToDate((String)date, (String)format));
        return cal.get(7) - 1;
    }

    public static boolean isDate(String date) {
        try {
            ((DateFormat)DATE_FORMAT.get()).parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static Date getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return DateUtils.formatStrToDate((String)DateUtils.formatDateToStr((Date)cal.getTime(), null), null);
    }

    public static String getCurrentDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return localDateTime.format(dateTimeFormatter);
    }

    public static String getCurrentDate() {
        LocalDate localDate = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return localDate.format(dateTimeFormatter);
    }
}

