/*
 * Decompiled with CFR 0.152.
 */
package cn.openx.boot.framework.booster.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.openx.boot.framework.booster.domian.enums.CommEnum;
import cn.openx.boot.framework.booster.entity.BaseEntity;
import cn.openx.boot.framework.booster.util.dto.DtoUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.common.Mapper;
import tk.mybatis.mapper.entity.Example;

public class BaseCurdService<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseCurdService.class);
    @Autowired
    public Mapper<T> mapper;

    public String getCurrentUser() {
        return "noLoginUser";
    }

    public String generateId() {
        return IdUtil.simpleUUID();
    }

    public Integer baseInsert(T t) {
        if (t instanceof BaseEntity) {
            if (StrUtil.isBlank((CharSequence)((BaseEntity)t).getId())) {
                ((BaseEntity)t).setId(this.generateId());
            }
            this.setBaseData((BaseEntity)t);
            return this.mapper.insertSelective(t);
        }
        return -1;
    }

    public Integer baseInsert(T t, String id) {
        if (t instanceof BaseEntity) {
            if (StrUtil.isNotEmpty((CharSequence)id)) {
                ((BaseEntity)t).setId(id);
            }
            return this.baseInsert(t);
        }
        return -1;
    }

    public Integer insertOrUpdate(T t, String uuId) {
        if (t instanceof BaseEntity) {
            String id = ((BaseEntity)t).getId();
            if (StrUtil.isNotBlank((CharSequence)id)) {
                return this.baseUpdateByPK(t);
            }
            return this.baseInsert(t, uuId);
        }
        return -1;
    }

    public Integer baseDeleteByPK(String id, T t) {
        if (StrUtil.isNotBlank((CharSequence)id)) {
            ((BaseEntity)t).setId(id);
        }
        return this.baseDeleteByPK(t);
    }

    public Integer baseDeleteByPK(T t) {
        if (t instanceof BaseEntity) {
            this.setDeleteDataInfo((BaseEntity)t);
            return this.updateById(t);
        }
        return -1;
    }

    public Integer baseDeleteByfields(T t, String field, String value) {
        if (t instanceof BaseEntity) {
            this.setDeleteDataInfo((BaseEntity)t);
            Example example = new Example(t.getClass(), true, true);
            example.createCriteria().andEqualTo(field, (Object)value);
            return this.mapper.updateByExampleSelective(t, (Object)example);
        }
        return -1;
    }

    public Integer baseUpdateByPK(T t) {
        if (t instanceof BaseEntity) {
            return this.updateById(t);
        }
        return -1;
    }

    public Integer baseUpdateAllByPK(T t) {
        if (t instanceof BaseEntity) {
            this.setModifyData((BaseEntity)t);
            Example example = new Example(t.getClass(), true, true);
            example.createCriteria().andEqualTo("id", (Object)((BaseEntity)t).getId());
            return this.mapper.updateByExample(t, (Object)example);
        }
        return -1;
    }

    private Integer updateById(T t) {
        this.setModifyData((BaseEntity)t);
        Example example = new Example(t.getClass(), true, true);
        example.createCriteria().andEqualTo("id", (Object)((BaseEntity)t).getId());
        return this.mapper.updateByExampleSelective(t, (Object)example);
    }

    public Integer baseDisableByPK(T t) {
        if (t instanceof BaseEntity) {
            ((BaseEntity)t).setIsValid("0");
            return this.updateById(t);
        }
        return -1;
    }

    public Integer baseDisableByPK(String id, T t) {
        if (StrUtil.isNotBlank((CharSequence)id)) {
            ((BaseEntity)t).setId(id);
        }
        return this.baseDisableByPK(t);
    }

    public Integer baseEnableByPK(T t) {
        if (t instanceof BaseEntity) {
            ((BaseEntity)t).setIsValid("1");
            return this.updateById(t);
        }
        return -1;
    }

    public Integer baseEnableByPK(String id, T t) {
        if (StrUtil.isNotBlank((CharSequence)id)) {
            ((BaseEntity)t).setId(id);
        }
        return this.baseEnableByPK(t);
    }

    public T baseSelectByPK(T t) {
        ((BaseEntity)t).setIsDelete("0");
        return (T)this.baseSelectByPKAndNotCareOthers(t);
    }

    public T baseSelectByPKAndNotCareOthers(T t) {
        if (t instanceof BaseEntity) {
            return (T)this.mapper.selectOne(t);
        }
        return null;
    }

    protected List<T> baseSelectListByObjectAllowDelete(T t) {
        Object changeT = DtoUtils.setNullValue(t);
        List list = new ArrayList();
        if (t instanceof BaseEntity) {
            Example example = this.getExample(changeT);
            example.setOrderByClause("DATE_CREATE DESC");
            list = this.mapper.selectByExample((Object)example);
        }
        return list;
    }

    public List<T> baseSelectListByObject(T t) {
        ((BaseEntity)t).setIsDelete("0");
        return this.baseSelectListByObjectAllowDelete(t);
    }

    public List<T> baseSelectListByObjectOrderByClause(T t, String orderByClause) {
        List list = new ArrayList();
        if (t instanceof BaseEntity) {
            ((BaseEntity)t).setIsDelete("0");
            Example example = this.getExample(t);
            example.setOrderByClause(orderByClause);
            list = this.mapper.selectByExample((Object)example);
        }
        return list;
    }

    private Example getExample(T t) {
        Field[] allFields;
        BaseEntity baseEntity = (BaseEntity)t;
        String searchType = baseEntity.getSearchType();
        Example example = new Example(t.getClass(), true, true);
        Example.Criteria criteria = example.createCriteria();
        for (Field field : allFields = FieldUtils.getAllFields(t.getClass())) {
            field.setAccessible(true);
            try {
                if (!ObjectUtil.isNotNull((Object)field.get(t)) || "serialVersionUID".equals(field.getName()) || "searchType".equals(field.getName())) continue;
                Object fieldObj = field.get(t);
                if (StrUtil.isBlank((CharSequence)searchType) || !(fieldObj instanceof String)) {
                    criteria.andEqualTo(field.getName(), fieldObj);
                    continue;
                }
                criteria.andLike(field.getName(), this.getSearchStr(fieldObj, searchType));
            }
            catch (IllegalAccessException e) {
                log.error("\u901a\u7528\u4ee3\u7801\uff0c\u83b7\u53d6t\u5185\u975e\u7a7a\u5c5e\u6027\uff0c\u53d1\u751f\u5f02\u5e38{}", (Throwable)e);
            }
        }
        return example;
    }

    public T baseSelectOneByObject(T t) {
        if (t instanceof BaseEntity) {
            ((BaseEntity)t).setIsDelete("0");
            return (T)this.mapper.selectOne(t);
        }
        return null;
    }

    private void setBaseData(BaseEntity t) {
        t.setCreateOpr(this.getCurrentUser());
        t.setDateCreate((Date)DateUtil.date());
        t.setIsDelete(CommEnum.NO.getCode());
        t.setIsValid(CommEnum.YES.getCode());
        this.setModifyData(t);
    }

    private void setModifyData(BaseEntity t) {
        t.setModifyOpr(this.getCurrentUser());
        t.setDateModify((Date)DateUtil.date());
    }

    private void setDeleteData(BaseEntity t) {
        t.setIsValid("0");
        t.setIsDelete("1");
    }

    private void setDeleteDataInfo(BaseEntity t) {
        this.setDeleteData(t);
        this.setModifyData(t);
    }

    private String getSearchStr(Object fieldObj, String searchType) {
        String fieldStr = String.valueOf(fieldObj);
        switch (searchType) {
            case "like": {
                fieldStr = "%".concat(fieldStr).concat("%");
                break;
            }
            case "leftLike": {
                fieldStr = "%".concat(fieldStr);
                break;
            }
            case "rightLike": {
                fieldStr = fieldStr.concat("%");
                break;
            }
            default: {
                fieldStr = fieldStr.concat("%");
                log.error("\u672a\u80fd\u8bc6\u522b\u7684searcheType\uff1a{}", (Object)searchType);
            }
        }
        return fieldStr;
    }
}

