/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CollectionUtils {
    @SafeVarargs
    public static <E> Set<E> asSet(E ... elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptySet();
        }
        if (elements.length == 1) {
            return Collections.singleton(elements[0]);
        }
        LinkedHashSet set = new LinkedHashSet(elements.length * 4 / 3 + 1);
        Collections.addAll(set, elements);
        return set;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static int size(Collection<?> c) {
        return c != null ? c.size() : 0;
    }

    public static int size(Map<?, ?> m) {
        return m != null ? m.size() : 0;
    }

    @SafeVarargs
    public static <E> List<E> asList(E ... elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(elements);
    }

    static int computeListCapacity(int arraySize) {
        return (int)Math.min(5L + (long)arraySize + (long)(arraySize / 10), Integer.MAX_VALUE);
    }
}

