/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.executer;

import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.sql.SqlExecuter;
import cn.tenmg.sqltool.sql.utils.FieldUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SelectSqlExecuter<T>
implements SqlExecuter<List<T>> {
    private static final long serialVersionUID = -1602037760808777740L;
    protected Class<T> type;

    public SelectSqlExecuter() {
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public SelectSqlExecuter(Class<T> type) {
        this.type = type;
    }

    @Override
    public ResultSet execute(PreparedStatement ps) throws SQLException {
        return ps.executeQuery();
    }

    @Override
    public List<T> execute(PreparedStatement ps, ResultSet rs) throws SQLException {
        ArrayList<Object> rows = new ArrayList<Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        if (String.class.isAssignableFrom(this.type) || Number.class.isAssignableFrom(this.type) || Date.class.isAssignableFrom(this.type) || BigDecimal.class.isAssignableFrom(this.type)) {
            while (rs.next()) {
                rows.add(rs.getObject(1));
            }
        } else {
            HashMap<String, Integer> feildNames = new HashMap<String, Integer>();
            for (int i = 1; i <= columnCount; ++i) {
                String feildName = StringUtils.toCamelCase(rsmd.getColumnLabel(i), "_", false);
                feildNames.put(feildName, i);
            }
            HashMap<Integer, Field> fieldMap = new HashMap<Integer, Field>();
            Class<T> current = this.type;
            while (!Object.class.equals(current)) {
                FieldUtils.parseFields(feildNames, fieldMap, current.getDeclaredFields());
                current = current.getSuperclass();
            }
            while (rs.next()) {
                try {
                    T row = this.type.newInstance();
                    for (int i = 1; i <= columnCount; ++i) {
                        Field field = (Field)fieldMap.get(i);
                        if (field == null) continue;
                        field.set(row, rs.getObject(i));
                    }
                    rows.add(row);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new DataAccessException(e);
                }
            }
        }
        return rows;
    }
}

