/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.sql.dialect;

import cn.tenmg.sqltool.config.annotion.Column;
import cn.tenmg.sqltool.config.annotion.Id;
import cn.tenmg.sqltool.dsql.JdbcSql;
import cn.tenmg.sqltool.exception.ColumnNotFoundException;
import cn.tenmg.sqltool.exception.DataAccessException;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.meta.EntityMeta;
import cn.tenmg.sqltool.sql.meta.FieldMeta;
import cn.tenmg.sqltool.utils.EntityUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MySQLDialect
implements SQLDialect {
    private static final long serialVersionUID = 7189284927835898553L;
    private static final String INSERT_IGNORE = "INSERT IGNORE INTO %s (%s) VALUES (%s)";
    private static final String SAVE = "INSERT INTO %s (%s) VALUES (%s) ON DUPLICATE KEY UPDATE %s";

    public static final MySQLDialect getInstance() {
        return InstanceHolder.INSTANCE;
    }

    protected static EntityMeta getCachedEntityMeta(Class<?> type) {
        return (EntityMeta)EntityMetaCacheHolder.CACHE.get(type);
    }

    protected static synchronized void cacheEntityMeta(Class<?> type, EntityMeta entityMeta) {
        EntityMetaCacheHolder.CACHE.put(type, entityMeta);
    }

    @Override
    public <T> JdbcSql save(T obj) {
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = MySQLDialect.getCachedEntityMeta(type);
        boolean flag = false;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        StringBuilder sets = new StringBuilder();
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                flag = MySQLDialect.parse(obj, columns, values, sets, params, fieldMetas);
                entityMeta.setFieldMetas(fieldMetas);
                MySQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Object param = fieldMeta.getField().get(obj);
                    if (param == null) continue;
                    params.add(param);
                    if (flag) {
                        MySQLDialect.appendComma(columns, values);
                    } else {
                        flag = true;
                    }
                    MySQLDialect.appendColumnAndParam(columns, values, columnName);
                    if (fieldMeta.isId()) continue;
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    MySQLDialect.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (flag) {
            return MySQLDialect.saveJdbcSql(entityMeta.getTableName(), columns, values, sets, params);
        }
        throw new ColumnNotFoundException(String.format("Not null column not found in class %s, please use @Column to config fields and make sure at lease one of them is not null", type.getName()));
    }

    @Override
    public <T> JdbcSql save(T obj, String[] hardFields) {
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = MySQLDialect.getCachedEntityMeta(type);
        boolean flag = false;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        StringBuilder sets = new StringBuilder();
        HashSet<String> hardFieldSet = new HashSet<String>();
        for (int i = 0; i < hardFields.length; ++i) {
            hardFieldSet.add(hardFields[i]);
        }
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                flag = MySQLDialect.parse(obj, columns, values, sets, params, fieldMetas, hardFieldSet);
                entityMeta.setFieldMetas(fieldMetas);
                MySQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Field field = fieldMeta.getField();
                    Object param = field.get(obj);
                    if (param == null && !hardFieldSet.contains(field.getName())) continue;
                    params.add(param);
                    if (flag) {
                        MySQLDialect.appendComma(columns, values);
                    } else {
                        flag = true;
                    }
                    MySQLDialect.appendColumnAndParam(columns, values, columnName);
                    if (fieldMeta.isId()) continue;
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    MySQLDialect.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (flag) {
            return MySQLDialect.saveJdbcSql(entityMeta.getTableName(), columns, values, sets, params);
        }
        throw new ColumnNotFoundException(String.format("Not null or hard save column not found in class %s, please use @Column to config fields and make sure at lease one of them is not null or hard save", type.getName()));
    }

    @Override
    public <T> JdbcSql hardSave(T obj) {
        Class<?> type = obj.getClass();
        EntityMeta entityMeta = MySQLDialect.getCachedEntityMeta(type);
        boolean columnNotFound = false;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        StringBuilder sets = new StringBuilder();
        try {
            if (entityMeta == null) {
                entityMeta = new EntityMeta();
                entityMeta.setTableName(EntityUtils.getTableName(type));
                ArrayList<FieldMeta> fieldMetas = new ArrayList<FieldMeta>();
                columnNotFound = MySQLDialect.hardParse(obj, columns, values, sets, params, fieldMetas);
                entityMeta.setFieldMetas(fieldMetas);
                MySQLDialect.cacheEntityMeta(type, entityMeta);
            } else {
                boolean setsFlag = false;
                List<FieldMeta> fieldMetas = entityMeta.getFieldMetas();
                int size = fieldMetas.size();
                for (int i = 0; i < size; ++i) {
                    FieldMeta fieldMeta = fieldMetas.get(i);
                    String columnName = fieldMeta.getColumnName();
                    Field field = fieldMeta.getField();
                    params.add(field.get(obj));
                    if (columnNotFound) {
                        MySQLDialect.appendComma(columns, values);
                    } else {
                        columnNotFound = true;
                    }
                    MySQLDialect.appendColumnAndParam(columns, values, columnName);
                    if (fieldMeta.isId()) continue;
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    MySQLDialect.appendSet(sets, columnName);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DataAccessException(e);
        }
        if (columnNotFound) {
            return MySQLDialect.saveJdbcSql(entityMeta.getTableName(), columns, values, sets, params);
        }
        throw new ColumnNotFoundException(String.format("Column not found in class %s, please use @Column to config fields", type.getName()));
    }

    private static final <T> boolean parse(T obj, StringBuilder columns, StringBuilder values, StringBuilder sets, List<Object> params, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldMap.containsKey(fieldName)) continue;
                fieldMap.put(fieldName, Boolean.TRUE);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                Object param = field.get(obj);
                if (param != null) {
                    params.add(param);
                    if (flag) {
                        MySQLDialect.appendComma(columns, values);
                    } else {
                        flag = true;
                    }
                    MySQLDialect.appendColumnAndParam(columns, values, columnName);
                    if (field.getAnnotation(Id.class) == null) {
                        fieldMeta.setId(false);
                        if (setsFlag) {
                            sets.append(", ");
                        } else {
                            setsFlag = true;
                        }
                        MySQLDialect.appendSet(sets, columnName);
                    } else {
                        fieldMeta.setId(true);
                    }
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private static final <T> boolean parse(T obj, StringBuilder columns, StringBuilder values, StringBuilder sets, List<Object> params, List<FieldMeta> fieldMetas, Set<String> hardFieldSet) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldMap.containsKey(fieldName)) continue;
                fieldMap.put(fieldName, Boolean.TRUE);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                Object param = field.get(obj);
                if (param != null || hardFieldSet.contains(field.getName())) {
                    params.add(param);
                    if (flag) {
                        MySQLDialect.appendComma(columns, values);
                    } else {
                        flag = true;
                    }
                    MySQLDialect.appendColumnAndParam(columns, values, columnName);
                    if (field.getAnnotation(Id.class) == null) {
                        fieldMeta.setId(false);
                        if (setsFlag) {
                            sets.append(", ");
                        } else {
                            setsFlag = true;
                        }
                        MySQLDialect.appendSet(sets, columnName);
                    } else {
                        fieldMeta.setId(true);
                    }
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private static final <T> boolean hardParse(T obj, StringBuilder columns, StringBuilder values, StringBuilder sets, List<Object> params, List<FieldMeta> fieldMetas) throws IllegalArgumentException, IllegalAccessException {
        boolean flag = false;
        boolean setsFlag = false;
        Class<?> current = obj.getClass();
        HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
        while (!Object.class.equals(current)) {
            Field[] declaredFields = current.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                String fieldName = field.getName();
                if (fieldMap.containsKey(fieldName)) continue;
                fieldMap.put(fieldName, Boolean.TRUE);
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                field.setAccessible(true);
                String columnName = column.name();
                if (StringUtils.isBlank(columnName)) {
                    columnName = StringUtils.camelToUnderline(fieldName, true);
                }
                FieldMeta fieldMeta = new FieldMeta(field, columnName);
                params.add(field.get(obj));
                if (flag) {
                    MySQLDialect.appendComma(columns, values);
                } else {
                    flag = true;
                }
                MySQLDialect.appendColumnAndParam(columns, values, columnName);
                if (field.getAnnotation(Id.class) == null) {
                    fieldMeta.setId(false);
                    if (setsFlag) {
                        sets.append(", ");
                    } else {
                        setsFlag = true;
                    }
                    MySQLDialect.appendSet(sets, columnName);
                } else {
                    fieldMeta.setId(true);
                }
                fieldMetas.add(fieldMeta);
            }
            current = current.getSuperclass();
        }
        return flag;
    }

    private static final void appendComma(StringBuilder columns, StringBuilder values) {
        columns.append(", ");
        values.append(", ");
    }

    private static final void appendColumnAndParam(StringBuilder columns, StringBuilder values, String columnName) {
        columns.append(columnName);
        values.append("?");
    }

    private static final void appendSet(StringBuilder sets, String columnName) {
        sets.append(columnName).append(" = VALUES(").append(columnName).append(")");
    }

    private static final JdbcSql saveJdbcSql(String tableName, StringBuilder columns, StringBuilder values, StringBuilder sets, List<Object> params) {
        if (sets.length() > 0) {
            return new JdbcSql(String.format(SAVE, tableName, columns, values, sets), params);
        }
        return new JdbcSql(String.format(INSERT_IGNORE, tableName, columns, values), params);
    }

    private static final class EntityMetaCacheHolder {
        private static volatile Map<Class<?>, EntityMeta> CACHE = new HashMap();

        private EntityMetaCacheHolder() {
        }
    }

    private static class InstanceHolder {
        private static final MySQLDialect INSTANCE = new MySQLDialect();

        private InstanceHolder() {
        }
    }
}

