/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool.dsql.utils;

import cn.tenmg.sqltool.dsql.JdbcSql;
import cn.tenmg.sqltool.dsql.Sql;
import cn.tenmg.sqltool.dsql.utils.MacroUtils;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DsqlUtils {
    private static final char SINGLE_QUOTATION_MARK = '\'';
    private static final char BLANK_SPACE = ' ';
    private static final char PARAM_BEGIN = ':';

    public static Sql parse(String source, Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank(source)) {
            return new Sql(source, params);
        }
        int len = source.length();
        if (len < 3) {
            return new Sql(source, params);
        }
        int deep = 0;
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isDynamic = false;
        boolean isParam = false;
        StringBuilder sql = new StringBuilder();
        StringBuilder paramName = new StringBuilder();
        HashMap<String, Object> usedParams = new HashMap<String, Object>();
        HashMap<Integer, Boolean> inValidMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, Set<String>> validMap = new HashMap<Integer, Set<String>>();
        HashMap<Integer, StringBuilder> dsqlMap = new HashMap<Integer, StringBuilder>();
        HashMap<Integer, Map<String, Object>> contexts = new HashMap<Integer, Map<String, Object>>();
        for (int i = 0; i < len; ++i) {
            String name;
            char c = source.charAt(i);
            if (isString) {
                if (DsqlUtils.isStringEnd(a, b, c)) {
                    isString = false;
                }
                if (deep > 0) {
                    ((StringBuilder)dsqlMap.get(deep)).append(c);
                } else {
                    sql.append(c);
                }
            } else if (c == '\'') {
                isString = true;
                if (deep > 0) {
                    ((StringBuilder)dsqlMap.get(deep)).append(c);
                } else {
                    sql.append(c);
                }
            } else if (isDynamic) {
                StringBuilder dsql;
                Object value;
                if (DsqlUtils.isDynamicEnd(c)) {
                    if (isParam) {
                        isParam = false;
                        name = paramName.toString();
                        value = params.get(name);
                        if (value != null) {
                            ((Set)validMap.get(deep)).add(name);
                            paramName.setLength(0);
                        } else if (deep > 0) {
                            inValidMap.put(deep, Boolean.TRUE);
                        }
                    }
                    if (inValidMap.get(deep) == null) {
                        DsqlUtils.processDsql(params, sql, dsqlMap, usedParams, inValidMap, validMap, contexts, deep, false);
                        --deep;
                    } else if (deep > 0) {
                        DsqlUtils.processDsql(params, sql, dsqlMap, usedParams, inValidMap, validMap, contexts, deep, true);
                        --deep;
                    }
                    if (deep < 1) {
                        isDynamic = false;
                        DsqlUtils.deleteRedundantBlank(sql);
                    } else {
                        DsqlUtils.deleteRedundantBlank((StringBuilder)dsqlMap.get(deep));
                    }
                } else if (isParam) {
                    if (DsqlUtils.isParamChar(c)) {
                        paramName.append(c);
                        dsql = (StringBuilder)dsqlMap.get(deep);
                        if (dsql == null) {
                            dsql = new StringBuilder();
                            dsqlMap.put(deep, dsql);
                        }
                        dsql.append(c);
                    } else {
                        StringBuilder dsql2;
                        isParam = false;
                        name = paramName.toString();
                        value = params.get(name);
                        if (value != null) {
                            validMap.get(deep).add(name);
                        } else if (deep >= 0) {
                            inValidMap.put(deep, Boolean.TRUE);
                        }
                        paramName.setLength(0);
                        if (DsqlUtils.isDynamicBegin(b, c)) {
                            dsql2 = dsqlMap.get(deep);
                            dsql2.deleteCharAt(dsql2.length() - 1);
                            dsqlMap.put(++deep, new StringBuilder());
                            validMap.put(deep, new HashSet());
                        } else {
                            dsql2 = dsqlMap.get(deep);
                            if (dsql2 == null) {
                                dsql2 = new StringBuilder();
                                dsqlMap.put(deep, dsql2);
                            }
                            dsql2.append(c);
                        }
                    }
                } else if (DsqlUtils.isDynamicBegin(b, c)) {
                    dsql = (StringBuilder)dsqlMap.get(deep);
                    dsql.deleteCharAt(dsql.length() - 1);
                    dsqlMap.put(++deep, new StringBuilder());
                    validMap.put(deep, new HashSet());
                } else {
                    if (DsqlUtils.isParamBegin(b, c)) {
                        isParam = true;
                        paramName.setLength(0);
                        paramName.append(c);
                    }
                    if ((dsql = (StringBuilder)dsqlMap.get(deep)) == null) {
                        dsql = new StringBuilder();
                        dsqlMap.put(deep, dsql);
                    }
                    dsql.append(c);
                }
            } else if (DsqlUtils.isDynamicBegin(b, c)) {
                isDynamic = true;
                sql.deleteCharAt(sql.length() - 1);
                validMap.put(++deep, new HashSet());
            } else {
                if (isParam) {
                    if (DsqlUtils.isParamChar(c)) {
                        paramName.append(c);
                        if (i == len - 1) {
                            name = paramName.toString();
                            usedParams.put(name, params.get(name));
                        }
                    } else {
                        isParam = false;
                        name = paramName.toString();
                        usedParams.put(name, params.get(name));
                        if (i < len - 1) {
                            paramName.setLength(0);
                        }
                    }
                } else if (DsqlUtils.isParamBegin(b, c)) {
                    isParam = true;
                    paramName.setLength(0);
                    paramName.append(c);
                }
                sql.append(c);
            }
            a = b;
            b = c;
        }
        return new Sql(sql.toString(), usedParams);
    }

    public static Sql parse(String source, Object ... params) {
        Map<String, Object> paramsMap = new HashMap<String, Object>();
        if (params != null) {
            if (params.length == 1 && params[0] instanceof Map) {
                paramsMap = (Map)params[0];
            } else {
                for (int i = 0; i < params.length; ++i) {
                    paramsMap.put((String)params[i], params[++i]);
                }
            }
        }
        return DsqlUtils.parse(source, paramsMap);
    }

    private static final void processDsql(Map<String, Object> params, StringBuilder sql, HashMap<Integer, StringBuilder> dsqlMap, Map<String, Object> usedParams, HashMap<Integer, Boolean> inValidMap, HashMap<Integer, Set<String>> validMap, HashMap<Integer, Map<String, Object>> contexts, int deep, boolean emptyWhenNoMacro) {
        Map<String, Object> context = contexts.get(deep);
        if (context == null) {
            context = new HashMap<String, Object>();
            contexts.put(deep, context);
        }
        StringBuilder dsql = MacroUtils.execute(dsqlMap.get(deep), context, params, emptyWhenNoMacro);
        if (deep == 1) {
            sql.append((CharSequence)dsql);
            for (String name : validMap.get(deep)) {
                if (usedParams.containsKey(name) || dsql.indexOf(':' + name) < 0) continue;
                usedParams.put(name, params.get(name));
            }
        } else {
            dsqlMap.get(deep - 1).append((CharSequence)dsql);
        }
        dsqlMap.remove(deep);
        validMap.remove(deep);
        inValidMap.remove(deep);
    }

    private static boolean isDynamicBegin(char b, char c) {
        return b == '#' && c == '[';
    }

    private static boolean isDynamicEnd(char c) {
        return c == ']';
    }

    private static void deleteRedundantBlank(StringBuilder target) {
        int length;
        int i = length = target.length();
        while (i > 0) {
            char ch;
            if ((ch = target.charAt(--i)) <= ' ') continue;
            target.delete(i + 1, length);
            break;
        }
    }

    public static JdbcSql toJdbcSql(String source, Map<String, Object> params) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (StringUtils.isBlank(source)) {
            return new JdbcSql(source, paramList);
        }
        int len = source.length();
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isParam = false;
        StringBuilder sql = new StringBuilder();
        StringBuilder paramName = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            if (isString) {
                if (DsqlUtils.isStringEnd(a, b, c)) {
                    isString = false;
                }
                sql.append(c);
            } else if (c == '\'') {
                isString = true;
                sql.append(c);
            } else if (isParam) {
                if (DsqlUtils.isParamChar(c)) {
                    paramName.append(c);
                } else {
                    isParam = false;
                    DsqlUtils.paramEnd(params, sql, paramName, paramList);
                    sql.append(c);
                }
            } else if (DsqlUtils.isParamBegin(b, c)) {
                isParam = true;
                paramName.setLength(0);
                paramName.append(c);
                sql.setCharAt(sql.length() - 1, '?');
            } else {
                sql.append(c);
            }
            a = b;
            b = c;
        }
        if (isParam) {
            DsqlUtils.paramEnd(params, sql, paramName, paramList);
        }
        return new JdbcSql(sql.toString(), paramList);
    }

    private static void paramEnd(Map<String, Object> params, StringBuilder sql, StringBuilder paramName, List<Object> paramList) {
        String name = paramName.toString();
        Object value = params.get(name);
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (CollectionUtils.isEmpty(collection)) {
                    paramList.add(null);
                } else {
                    boolean flag = false;
                    Iterator it = collection.iterator();
                    while (it.hasNext()) {
                        if (flag) {
                            sql.append(", ?");
                        } else {
                            flag = true;
                        }
                        paramList.add(it.next());
                    }
                }
            } else if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                if (objects.length == 0) {
                    paramList.add(null);
                } else {
                    for (int j = 0; j < objects.length; ++j) {
                        if (j > 0) {
                            sql.append(", ?");
                        }
                        paramList.add(objects[j]);
                    }
                }
            } else {
                paramList.add(value);
            }
        } else {
            paramList.add(value);
        }
    }

    private static boolean is26LettersIgnoreCase(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isParamBegin(char b, char c) {
        return b == ':' && DsqlUtils.is26LettersIgnoreCase(c);
    }

    public static boolean isParamChar(char c) {
        return DsqlUtils.is26LettersIgnoreCase(c) || c >= '0' && c <= '9' || c == '_' || c == '-';
    }

    public static boolean isStringEnd(char a, char b, char c) {
        return (a == '\'' || a != '\'' && b != '\'') && c == '\'';
    }
}

