/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sqltool;

import cn.tenmg.sqltool.SqltoolFactory;
import cn.tenmg.sqltool.Transaction;
import cn.tenmg.sqltool.dsql.JdbcSql;
import cn.tenmg.sqltool.dsql.Sql;
import cn.tenmg.sqltool.dsql.utils.DsqlUtils;
import cn.tenmg.sqltool.exception.IllegalCallException;
import cn.tenmg.sqltool.exception.IllegalConfigException;
import cn.tenmg.sqltool.exception.NosuitableSQLDialectExeption;
import cn.tenmg.sqltool.exception.SQLException;
import cn.tenmg.sqltool.exception.TransactionException;
import cn.tenmg.sqltool.sql.DML;
import cn.tenmg.sqltool.sql.SQLDialect;
import cn.tenmg.sqltool.sql.SqlExecuter;
import cn.tenmg.sqltool.sql.dialect.MySQLDialect;
import cn.tenmg.sqltool.sql.executer.ExecuteSqlExecuter;
import cn.tenmg.sqltool.sql.executer.ExecuteUpdateSqlExecuter;
import cn.tenmg.sqltool.sql.executer.GetSqlExecuter;
import cn.tenmg.sqltool.sql.executer.SelectSqlExecuter;
import cn.tenmg.sqltool.sql.parser.GetDMLParser;
import cn.tenmg.sqltool.sql.parser.InsertDMLParser;
import cn.tenmg.sqltool.utils.CollectionUtils;
import cn.tenmg.sqltool.utils.JSONUtils;
import cn.tenmg.sqltool.utils.JdbcUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SqltoolContext
implements Serializable {
    private static final long serialVersionUID = -840162594918947327L;
    private static final Logger log = Logger.getLogger(SqltoolContext.class);
    private static String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final int DEFAULT_BATCH_SIZE = 500;
    private SqltoolFactory sqltoolFactory;
    private boolean showSql = true;
    private int defaultBatchSize = 500;
    private static ThreadLocal<Connection> currentConnection = new ThreadLocal();

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public SqltoolContext() {
    }

    public SqltoolContext(SqltoolFactory sqltoolFactory) {
        this.sqltoolFactory = sqltoolFactory;
    }

    public SqltoolContext(SqltoolFactory sqltoolFactory, boolean showSql) {
        this.sqltoolFactory = sqltoolFactory;
        this.showSql = showSql;
    }

    public SqltoolContext(SqltoolFactory sqltoolFactory, boolean showSql, int defaultBatchSize) {
        this.sqltoolFactory = sqltoolFactory;
        this.showSql = showSql;
        this.defaultBatchSize = defaultBatchSize;
    }

    public int insert(Map<String, String> options, Object obj) {
        DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
        String sql = dml.getSql();
        List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
        return this.execute(options, sql, params, ExecuteUpdateSqlExecuter.getInstance());
    }

    public int[] insert(Map<String, String> options, List<Object> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return null;
        }
        DML dml = InsertDMLParser.getInstance().parse(rows.get(0).getClass());
        return this.executeBatch(options, dml.getSql(), rows, dml.getFields());
    }

    public void insertBatch(Map<String, String> options, List<Object> rows) {
        this.insertBatch(options, rows, 500);
    }

    public void insertBatch(Map<String, String> options, List<Object> rows, int batchSize) {
        if (!CollectionUtils.isEmpty(rows)) {
            DML dml = InsertDMLParser.getInstance().parse(rows.get(0).getClass());
            this.executeBatch(options, dml.getSql(), rows, dml.getFields(), batchSize);
        }
    }

    public <T extends Serializable> int save(Map<String, String> options, T obj) {
        JdbcSql jdbcSql = SqltoolContext.getSQLDialect(options).save(obj);
        return this.execute(options, jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance());
    }

    public <T extends Serializable> void save(Map<String, String> options, List<T> rows) {
        this.saveTransaction(options, rows);
    }

    public <T extends Serializable> void saveBatch(Map<String, String> options, List<T> rows) {
        this.executeBatch(options, rows, this.defaultBatchSize);
    }

    public <T extends Serializable> void saveBatch(Map<String, String> options, List<T> rows, int batchSize) {
        this.executeBatch(options, rows, batchSize);
    }

    public <T extends Serializable> int save(Map<String, String> options, T obj, String[] hardFields) {
        JdbcSql jdbcSql = SqltoolContext.getSQLDialect(options).save(obj, hardFields);
        return this.execute(options, jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance());
    }

    public <T extends Serializable> void save(Map<String, String> options, List<T> rows, String[] hardFields) {
        this.saveTransaction(options, rows, hardFields);
    }

    public <T extends Serializable> void saveBatch(Map<String, String> options, List<T> rows, String[] hardFields) {
        this.executeBatch(options, rows, hardFields, this.defaultBatchSize);
    }

    public <T extends Serializable> void saveBatch(Map<String, String> options, List<T> rows, String[] hardFields, int batchSize) {
        this.executeBatch(options, rows, hardFields, batchSize);
    }

    public <T extends Serializable> int hardSave(Map<String, String> options, T obj) {
        JdbcSql jdbcSql = SqltoolContext.getSQLDialect(options).hardSave(obj);
        return this.execute(options, jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance());
    }

    public <T extends Serializable> void hardSave(Map<String, String> options, List<T> rows) {
        this.hardSaveTransaction(options, rows);
    }

    public <T extends Serializable> void hardSaveBatch(Map<String, String> options, List<T> rows) {
        this.executHardBatch(options, rows, this.defaultBatchSize);
    }

    public <T extends Serializable> void hardSaveBatch(Map<String, String> options, List<T> rows, int batchSize) {
        this.executHardBatch(options, rows, batchSize);
    }

    public <T extends Serializable> T get(Map<String, String> options, T obj) {
        Class<?> type = obj.getClass();
        DML dml = GetDMLParser.getInstance().parse(type);
        return (T)((Serializable)this.execute(options, dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new GetSqlExecuter(type)));
    }

    public <T extends Serializable> T get(Map<String, String> options, Class<T> type, String dsql, Object ... params) {
        return this.get(options, this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> T get(Map<String, String> options, Class<T> type, String dsql, Map<String, Object> params) {
        return this.get(options, this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Map<String, String> options, Class<T> type, String dsql, Object ... params) {
        return this.select(options, this.sqltoolFactory.parse(dsql, params), type);
    }

    public <T extends Serializable> List<T> select(Map<String, String> options, Class<T> type, String dsql, Map<String, Object> params) {
        return this.select(options, this.sqltoolFactory.parse(dsql, params), type);
    }

    public boolean execute(Map<String, String> options, String dsql, Object ... params) {
        return this.execute(options, this.sqltoolFactory.parse(dsql, params));
    }

    public boolean execute(Map<String, String> options, String dsql, Map<String, Object> params) {
        return this.execute(options, this.sqltoolFactory.parse(dsql, params));
    }

    public int executeUpdate(Map<String, String> options, String dsql, Object ... params) {
        return this.executeUpdate(options, this.sqltoolFactory.parse(dsql, params));
    }

    public int executeUpdate(Map<String, String> options, String dsql, Map<String, Object> params) {
        return this.executeUpdate(options, this.sqltoolFactory.parse(dsql, params));
    }

    public void beginTransaction(Map<String, String> options) {
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            currentConnection.set(con);
        }
        catch (java.sql.SQLException e) {
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    public boolean execute(String dsql, Object ... params) {
        return this.execute(this.sqltoolFactory.parse(dsql, params));
    }

    public boolean execute(String dsql, Map<String, Object> params) {
        return this.execute(this.sqltoolFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Object ... params) {
        return this.executeUpdate(this.sqltoolFactory.parse(dsql, params));
    }

    public int executeUpdate(String dsql, Map<String, Object> params) {
        return this.executeUpdate(this.sqltoolFactory.parse(dsql, params));
    }

    public void rollback() {
        Connection con = SqltoolContext.getCurrentConnection();
        try {
            con.rollback();
        }
        catch (java.sql.SQLException e) {
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
            currentConnection.remove();
        }
    }

    public void commit() {
        Connection con = SqltoolContext.getCurrentConnection();
        try {
            con.commit();
        }
        catch (java.sql.SQLException e) {
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        finally {
            JdbcUtils.close(con);
            currentConnection.remove();
        }
    }

    public void execute(Map<String, String> options, Transaction transaction) {
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            currentConnection.set(con);
            transaction.execute(new SqltoolExecutor(this.showSql, this.sqltoolFactory, SqltoolContext.getSQLDialect(options)));
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            if (e instanceof ClassNotFoundException) {
                throw new IllegalConfigException(e);
            }
            if (e instanceof java.sql.SQLException) {
                JdbcUtils.close(con);
                throw new SQLException(e);
            }
            throw new TransactionException(e);
        }
    }

    private <T extends Serializable> T get(Map<String, String> options, Sql sql, Class<T> type) {
        return (T)((Serializable)this.execute(options, sql, new GetSqlExecuter<T>(type)));
    }

    private <T extends Serializable> List<T> select(Map<String, String> options, Sql sql, Class<T> type) {
        return (List)this.execute(options, sql, new SelectSqlExecuter<T>(type));
    }

    private boolean execute(Map<String, String> options, Sql sql) {
        return this.execute(options, sql, ExecuteSqlExecuter.getInstance());
    }

    private int executeUpdate(Map<String, String> options, Sql sql) {
        return this.execute(options, sql, ExecuteUpdateSqlExecuter.getInstance());
    }

    private <T> T execute(Map<String, String> options, Sql sql, SqlExecuter<T> sqlExecuter) {
        JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
        return this.execute(options, jdbcSql.getScript(), jdbcSql.getParams(), sqlExecuter);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Map<String, String> options, String sql, List<Object> params, SqlExecuter<T> sqlExecuter) {
        Connection con = null;
        T result = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            result = SqltoolContext.execute(con, sql, params, sqlExecuter, this.showSql);
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                JdbcUtils.close(con);
                throw new SQLException(e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalConfigException(e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.close(con);
                throw throwable;
            }
        }
        JdbcUtils.close(con);
        return result;
    }

    private static <T> T execute(Connection con, String sql, List<Object> params, SqlExecuter<T> sqlExecuter, boolean showSql) throws java.sql.SQLException {
        StringBuilder sb;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            JdbcUtils.setParams(ps, params);
            if (showSql) {
                sb = new StringBuilder();
                sb.append("Execute SQL: ").append(sql).append(LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            rs = sqlExecuter.execute(ps);
            sb = sqlExecuter.execute(ps, rs);
        }
        catch (java.sql.SQLException e) {
            try {
                JdbcUtils.close(rs);
                JdbcUtils.close(ps);
                throw e;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(rs);
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(ps);
        return (T)sb;
    }

    private <T> int[] executeBatch(Map<String, String> options, String sql, List<T> rows, List<Field> fields) {
        Connection con = null;
        int[] counts = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            counts = SqltoolContext.executeBatch(this.showSql, con, sql, rows, fields);
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
        return counts;
    }

    private static <T> int[] executeBatch(boolean showSql, Connection con, String sql, List<T> rows, List<Field> fields) throws java.sql.SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            if (showSql) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                SqltoolContext.addBatch(ps, rows.get(i), fields);
            }
        }
        catch (java.sql.SQLException e) {
            ps.clearBatch();
            JdbcUtils.close(ps);
            throw e;
        }
        return SqltoolContext.commitBatch(con, ps);
    }

    private <T> void executeBatch(Map<String, String> options, String sql, List<T> rows, List<Field> fields, int batchSize) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            ps = con.prepareStatement(sql);
            if (this.showSql) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int i;
                int end = (current + 1) * batchSize;
                if (end < size) {
                    for (i = current * batchSize; i < end; ++i) {
                        SqltoolContext.addBatch(ps, rows.get(i), fields);
                    }
                } else {
                    while (i < size) {
                        SqltoolContext.addBatch(ps, rows.get(i), fields);
                        ++i;
                    }
                }
                SqltoolContext.commitBatch(con, ps);
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    private <T> void saveTransaction(Map<String, String> options, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = SqltoolContext.getSQLDialect(options);
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            SqltoolContext.saveTransaction(this.showSql, dialect, con, rows);
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    private static <T> void saveTransaction(boolean showSql, SQLDialect dialect, Connection con, List<T> rows) throws java.sql.SQLException {
        HashMap<String, PreparedStatement> pss = new HashMap<String, PreparedStatement>();
        try {
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                SqltoolContext.addBatch(dialect, con, pss, rows.get(i));
            }
        }
        catch (java.sql.SQLException e) {
            for (PreparedStatement ps : pss.values()) {
                ps.clearBatch();
                ps.close();
            }
            throw e;
        }
        SqltoolContext.commitBatch(con, pss, showSql);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> void saveTransaction(Map<String, String> options, List<T> rows, String[] hardFields) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = SqltoolContext.getSQLDialect(options);
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            SqltoolContext.saveTransaction(this.showSql, dialect, con, rows, hardFields);
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                JdbcUtils.close(con);
                throw new SQLException(e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalConfigException(e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.close(con);
                throw throwable;
            }
        }
        JdbcUtils.close(con);
    }

    private static <T> void saveTransaction(boolean showSql, SQLDialect dialect, Connection con, List<T> rows, String[] hardFields) throws java.sql.SQLException {
        HashMap<String, PreparedStatement> pss = new HashMap<String, PreparedStatement>();
        try {
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                SqltoolContext.addBatch(dialect, con, pss, rows.get(i), hardFields);
            }
        }
        catch (java.sql.SQLException e) {
            for (PreparedStatement ps : pss.values()) {
                ps.clearBatch();
                ps.close();
            }
            throw e;
        }
        SqltoolContext.commitBatch(con, pss, showSql);
    }

    private <T> void hardSaveTransaction(Map<String, String> options, List<T> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = SqltoolContext.getSQLDialect(options);
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            SqltoolContext.hardSaveTransaction(this.showSql, dialect, con, rows);
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    private static <T> void hardSaveTransaction(boolean showSql, SQLDialect dialect, Connection con, List<T> rows) throws java.sql.SQLException {
        HashMap<String, PreparedStatement> pss = new HashMap<String, PreparedStatement>();
        try {
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                SqltoolContext.addHardBatch(dialect, con, pss, rows.get(i));
            }
        }
        catch (java.sql.SQLException e) {
            for (PreparedStatement ps : pss.values()) {
                ps.clearBatch();
                ps.close();
            }
            throw e;
        }
        SqltoolContext.commitBatch(con, pss, showSql);
    }

    private <T> void executeBatch(Map<String, String> options, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = SqltoolContext.getSQLDialect(options);
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int i;
                HashMap<String, PreparedStatement> pss = new HashMap<String, PreparedStatement>();
                int end = (current + 1) * batchSize;
                if (end < size) {
                    for (i = current * batchSize; i < end; ++i) {
                        SqltoolContext.addBatch(dialect, con, pss, rows.get(i));
                    }
                } else {
                    while (i < size) {
                        SqltoolContext.addBatch(dialect, con, pss, rows.get(i));
                        ++i;
                    }
                }
                SqltoolContext.commitBatch(con, pss, this.showSql);
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    private <T> void executeBatch(Map<String, String> options, List<T> rows, String[] hardFields, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = SqltoolContext.getSQLDialect(options);
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int i;
                HashMap<String, PreparedStatement> pss = new HashMap<String, PreparedStatement>();
                int end = (current + 1) * batchSize;
                if (end < size) {
                    for (i = current * batchSize; i < end; ++i) {
                        SqltoolContext.addBatch(dialect, con, pss, rows.get(i), hardFields);
                    }
                } else {
                    while (i < size) {
                        SqltoolContext.addBatch(dialect, con, pss, rows.get(i), hardFields);
                        ++i;
                    }
                }
                SqltoolContext.commitBatch(con, pss, this.showSql);
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    private <T> void executHardBatch(Map<String, String> options, List<T> rows, int batchSize) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        SQLDialect dialect = SqltoolContext.getSQLDialect(options);
        Connection con = null;
        try {
            Class.forName(options.get("driver"));
            con = DriverManager.getConnection(options.get("url"), options.get("user"), options.get("password"));
            con.setAutoCommit(false);
            int size = rows.size();
            int times = (int)Math.ceil((double)size / (double)batchSize);
            for (int current = 0; current < times; ++current) {
                int i;
                HashMap<String, PreparedStatement> pss = new HashMap<String, PreparedStatement>();
                int end = (current + 1) * batchSize;
                if (end < size) {
                    for (i = current * batchSize; i < end; ++i) {
                        SqltoolContext.addHardBatch(dialect, con, pss, rows.get(i));
                    }
                } else {
                    while (i < size) {
                        SqltoolContext.addHardBatch(dialect, con, pss, rows.get(i));
                        ++i;
                    }
                }
                SqltoolContext.commitBatch(con, pss, this.showSql);
            }
        }
        catch (java.sql.SQLException e) {
            try {
                con.rollback();
            }
            catch (java.sql.SQLException ex) {
                ex.printStackTrace();
            }
            JdbcUtils.close(con);
            throw new SQLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalConfigException(e);
        }
    }

    private static final <T> void addBatch(PreparedStatement ps, T row, List<Field> fields) throws java.sql.SQLException {
        JdbcUtils.setParams(ps, JdbcUtils.getParams(row, fields));
        ps.addBatch();
    }

    private static final int[] commitBatch(Connection con, PreparedStatement ps) throws java.sql.SQLException {
        int[] counts = null;
        try {
            counts = ps.executeBatch();
            con.commit();
            ps.clearBatch();
        }
        catch (java.sql.SQLException e) {
            throw e;
        }
        finally {
            JdbcUtils.close(ps);
        }
        return counts;
    }

    private static SQLDialect getSQLDialect(Map<String, String> options) {
        String url = options.get("url");
        if (url != null && url.contains("mysql")) {
            return MySQLDialect.getInstance();
        }
        throw new NosuitableSQLDialectExeption("There is no suitable SQL dialect provide for url: ".concat(url));
    }

    private static final <T> void addBatch(SQLDialect dialect, Connection con, Map<String, PreparedStatement> pss, T row) throws java.sql.SQLException {
        JdbcSql jdbcSql = dialect.save(row);
        String sql = jdbcSql.getScript();
        PreparedStatement ps = pss.get(sql);
        if (ps == null) {
            ps = con.prepareStatement(sql);
            pss.put(sql, ps);
        }
        JdbcUtils.setParams(ps, jdbcSql.getParams());
        ps.addBatch();
    }

    private static final <T> void addBatch(SQLDialect dialect, Connection con, Map<String, PreparedStatement> pss, T row, String[] hardFields) throws java.sql.SQLException {
        JdbcSql jdbcSql = dialect.save(row, hardFields);
        String sql = jdbcSql.getScript();
        PreparedStatement ps = pss.get(sql);
        if (ps == null) {
            ps = con.prepareStatement(sql);
            pss.put(sql, ps);
        }
        JdbcUtils.setParams(ps, jdbcSql.getParams());
        ps.addBatch();
    }

    private static final <T> void addHardBatch(SQLDialect dialect, Connection con, Map<String, PreparedStatement> pss, T row) throws java.sql.SQLException {
        JdbcSql jdbcSql = dialect.hardSave(row);
        String sql = jdbcSql.getScript();
        PreparedStatement ps = pss.get(sql);
        if (ps == null) {
            ps = con.prepareStatement(sql);
            pss.put(sql, ps);
        }
        JdbcUtils.setParams(ps, jdbcSql.getParams());
        ps.addBatch();
    }

    private static final void commitBatch(Connection con, Map<String, PreparedStatement> pss, boolean showSql) throws java.sql.SQLException {
        for (Map.Entry<String, PreparedStatement> entry : pss.entrySet()) {
            if (showSql) {
                log.info((Object)"Execute SQL: ".concat(entry.getKey()));
            }
            entry.getValue().executeBatch();
        }
        con.commit();
        for (PreparedStatement ps : pss.values()) {
            ps.clearBatch();
            ps.close();
        }
    }

    private static Connection getCurrentConnection() {
        Connection con = currentConnection.get();
        if (con == null) {
            throw new IllegalCallException("You must call beginTransaction first before you call this method");
        }
        return con;
    }

    private boolean execute(Sql sql) {
        Connection con = SqltoolContext.getCurrentConnection();
        JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
        PreparedStatement ps = null;
        boolean rs = false;
        try {
            String script = jdbcSql.getScript();
            List<Object> params = jdbcSql.getParams();
            ps = con.prepareStatement(script);
            JdbcUtils.setParams(ps, params);
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            rs = ps.execute();
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                JdbcUtils.close(ps);
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(ps);
        return rs;
    }

    private int executeUpdate(Sql sql) {
        Connection con = SqltoolContext.getCurrentConnection();
        JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
        PreparedStatement ps = null;
        int count = 0;
        try {
            String script = jdbcSql.getScript();
            List<Object> params = jdbcSql.getParams();
            ps = con.prepareStatement(script);
            JdbcUtils.setParams(ps, params);
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(script).append(LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            count = ps.executeUpdate();
        }
        catch (java.sql.SQLException e) {
            try {
                try {
                    con.rollback();
                }
                catch (java.sql.SQLException ex) {
                    ex.printStackTrace();
                }
                JdbcUtils.close(ps);
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(ps);
                throw throwable;
            }
        }
        JdbcUtils.close(ps);
        return count;
    }

    public static class SqltoolExecutor
    implements Serializable {
        private static final long serialVersionUID = -185528394193239604L;
        private boolean showSql = true;
        private SqltoolFactory sqltoolFactory;
        private SQLDialect dialect;

        public SqltoolExecutor(boolean showSql, SqltoolFactory sqltoolFactory, SQLDialect dialect) {
            this.showSql = showSql;
            this.sqltoolFactory = sqltoolFactory;
            this.dialect = dialect;
        }

        public int insert(Object obj) {
            DML dml = InsertDMLParser.getInstance().parse(obj.getClass());
            String sql = dml.getSql();
            List<Object> params = JdbcUtils.getParams(obj, dml.getFields());
            if (this.showSql) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute SQL: ").append(sql).append(LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                log.info((Object)sb.toString());
            }
            try {
                return (Integer)SqltoolContext.execute((Connection)currentConnection.get(), sql, params, ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public int[] insert(List<Object> rows) {
            if (CollectionUtils.isEmpty(rows)) {
                return null;
            }
            DML dml = InsertDMLParser.getInstance().parse(rows.get(0).getClass());
            String sql = dml.getSql();
            if (this.showSql) {
                log.info((Object)"Execute SQL: ".concat(sql));
            }
            try {
                return SqltoolContext.executeBatch(this.showSql, (Connection)currentConnection.get(), dml.getSql(), rows, dml.getFields());
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int save(T obj) {
            JdbcSql jdbcSql = this.dialect.save(obj);
            try {
                return (Integer)SqltoolContext.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> void save(List<T> rows) {
            if (CollectionUtils.isEmpty(rows)) {
                return;
            }
            try {
                SqltoolContext.saveTransaction(this.showSql, this.dialect, (Connection)currentConnection.get(), rows);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int save(T obj, String[] hardFields) {
            JdbcSql jdbcSql = this.dialect.save(obj, hardFields);
            try {
                return (Integer)SqltoolContext.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> void save(List<T> rows, String[] hardFields) {
            if (CollectionUtils.isEmpty(rows)) {
                return;
            }
            try {
                SqltoolContext.saveTransaction(this.showSql, this.dialect, (Connection)currentConnection.get(), rows, hardFields);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> int hardSave(T obj) {
            JdbcSql jdbcSql = this.dialect.hardSave(obj);
            try {
                return (Integer)SqltoolContext.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), ExecuteUpdateSqlExecuter.getInstance(), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> void hardSave(List<T> rows) {
            if (CollectionUtils.isEmpty(rows)) {
                return;
            }
            try {
                SqltoolContext.hardSaveTransaction(this.showSql, this.dialect, (Connection)currentConnection.get(), rows);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> T get(T obj) {
            Class<?> type = obj.getClass();
            DML dml = GetDMLParser.getInstance().parse(type);
            try {
                return (T)((Serializable)SqltoolContext.execute((Connection)currentConnection.get(), dml.getSql(), JdbcUtils.getParams(obj, dml.getFields()), new GetSqlExecuter(type), this.showSql));
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        public <T extends Serializable> T get(Map<String, String> options, Class<T> type, String dsql, Object ... params) {
            return this.get(this.sqltoolFactory.parse(dsql, params), type);
        }

        public <T extends Serializable> T get(Class<T> type, String dsql, Map<String, Object> params) {
            return this.get(this.sqltoolFactory.parse(dsql, params), type);
        }

        public <T extends Serializable> List<T> select(Class<T> type, String dsql, Object ... params) {
            return this.select(this.sqltoolFactory.parse(dsql, params), type);
        }

        public <T extends Serializable> List<T> select(Class<T> type, String dsql, Map<String, Object> params) {
            return this.select(this.sqltoolFactory.parse(dsql, params), type);
        }

        public boolean execute(String dsql, Object ... params) {
            return this.execute(this.sqltoolFactory.parse(dsql, params));
        }

        public boolean execute(String dsql, Map<String, Object> params) {
            return this.execute(this.sqltoolFactory.parse(dsql, params));
        }

        public int executeUpdate(String dsql, Object ... params) {
            return this.executeUpdate(this.sqltoolFactory.parse(dsql, params));
        }

        public int executeUpdate(String dsql, Map<String, Object> params) {
            return this.executeUpdate(this.sqltoolFactory.parse(dsql, params));
        }

        private boolean execute(Sql sql) {
            JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
            PreparedStatement ps = null;
            boolean rs = false;
            Connection con = (Connection)currentConnection.get();
            try {
                ps = con.prepareStatement(jdbcSql.getScript());
                JdbcUtils.setParams(ps, jdbcSql.getParams());
                rs = ps.execute();
            }
            catch (java.sql.SQLException e) {
                try {
                    try {
                        con.rollback();
                    }
                    catch (java.sql.SQLException ex) {
                        ex.printStackTrace();
                    }
                    JdbcUtils.close(ps);
                    throw new SQLException(e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            JdbcUtils.close(ps);
            return rs;
        }

        private int executeUpdate(Sql sql) {
            JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
            PreparedStatement ps = null;
            int count = 0;
            Connection con = (Connection)currentConnection.get();
            try {
                String script = jdbcSql.getScript();
                List<Object> params = jdbcSql.getParams();
                ps = con.prepareStatement(script);
                JdbcUtils.setParams(ps, params);
                if (this.showSql) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Execute SQL: ").append(script).append(LINE_SEPARATOR).append("Params: ").append(JSONUtils.toJSONString(params));
                    log.info((Object)sb.toString());
                }
                count = ps.executeUpdate();
            }
            catch (java.sql.SQLException e) {
                try {
                    try {
                        con.rollback();
                    }
                    catch (java.sql.SQLException ex) {
                        ex.printStackTrace();
                    }
                    JdbcUtils.close(ps);
                    throw new SQLException(e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(ps);
                    throw throwable;
                }
            }
            JdbcUtils.close(ps);
            return count;
        }

        private <T extends Serializable> T get(Sql sql, Class<T> type) {
            JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
            try {
                return (T)((Serializable)SqltoolContext.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), new GetSqlExecuter<T>(type), this.showSql));
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }

        private <T extends Serializable> List<T> select(Sql sql, Class<T> type) {
            JdbcSql jdbcSql = DsqlUtils.toJdbcSql(sql.getScript(), sql.getParams());
            try {
                return (List)SqltoolContext.execute((Connection)currentConnection.get(), jdbcSql.getScript(), jdbcSql.getParams(), new SelectSqlExecuter<T>(type), this.showSql);
            }
            catch (java.sql.SQLException e) {
                throw new SQLException(e);
            }
        }
    }
}

