/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.sparktool.sql.engine;

import cn.tenmg.dsql.utils.DateUtils;
import cn.tenmg.sparktool.sql.engine.AbstractSQLEngine;
import java.sql.Timestamp;
import java.util.Date;

public class OracleEngine
extends AbstractSQLEngine {
    private static final long serialVersionUID = -6048522993125955852L;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
    private static final String DATE_PATTERN = "YYYY-MM-DD HH24:MI:SS";
    private static final String TIMESTAMP_PATTERN = "YYYY-MM-DD HH24:MI:SS.FF6";
    private static final OracleEngine INSTANCE = new OracleEngine();

    private OracleEngine() {
    }

    public static final OracleEngine getInstance() {
        return INSTANCE;
    }

    @Override
    String parse(Date date) {
        if (date instanceof Timestamp) {
            return "TO_TIMESTAMP('".concat(DateUtils.format((Object)date, (String)TIMESTAMP_FORMAT)).concat("', '").concat(TIMESTAMP_PATTERN).concat("')");
        }
        return "TO_DATE('".concat(DateUtils.format((Object)date, (String)DATE_FORMAT)).concat("', '").concat(DATE_PATTERN).concat("')");
    }
}

