package cn.tenmg.hibernate.sqltool.service.impl;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;

import cn.tenmg.hibernate.sqltool.dao.Dao;
import cn.tenmg.hibernate.sqltool.service.Service;
import cn.tenmg.sqltool.data.Page;

/**
 * 虚数据库访问服务
 * 
 * @author 赵伟均 wjzhao@aliyun.com
 *
 * @param <P> 实体类
 */
public abstract class AbstractService<P> implements Service<P> {

	/**
	 * 获取数据库访问对象
	 * 
	 * @return 返回数据库访问对象
	 */
	protected abstract Dao getDao();

	protected Class<P> entityClass;

	@SuppressWarnings("unchecked")
	public AbstractService() {
		entityClass = (Class<P>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
	}

	@Override
	public P save(P p) {
		return getDao().save(p);
	}

	@Override
	public P get(Serializable id) {
		return getDao().get(entityClass, id);
	}

	@Override
	public Object[] get(String dsql, Object... params) {
		return getDao().get(dsql, params);
	}

	@Override
	public Object[] get(String dsql, Map<String, Object> params) {
		return getDao().get(dsql, params);
	}

	@Override
	public <T> T get(Class<T> type, String dsql, Object... params) {
		return getDao().get(type, dsql, params);
	}

	@Override
	public <T> T get(Class<T> type, String dsql, Map<String, Object> params) {
		return getDao().get(type, dsql, params);
	}

	@Override
	public List<Object[]> query(String dsql, Object... params) {
		return getDao().query(dsql, params);
	}

	@Override
	public List<Object[]> query(String dsql, Map<String, Object> params) {
		return getDao().query(dsql, params);
	}

	@Override
	public <T> List<T> query(Class<?> type, String dsql, Object... params) {
		return getDao().query(type, dsql, params);
	}

	@Override
	public <T> List<T> queryFirstCol(String dsql, Object... params) {
		return getDao().queryFirstCol(dsql, params);
	}

	@Override
	public <T> List<T> queryFirstCol(String dsql, Map<String, Object> params) {
		return getDao().queryFirstCol(dsql, params);
	}

	@Override
	public <T> List<T> query(Class<?> type, String dsql, Map<String, Object> params) {
		return getDao().query(type, dsql, params);
	}

	@Override
	public <T> T queryUnique(String dsql, Object... params) {
		return getDao().queryUnique(dsql, params);
	}

	@Override
	public <T> T queryUnique(String dsql, Map<String, Object> params) {
		return getDao().queryUnique(dsql, params);
	}

	@Override
	public <T> T queryUnique(Class<T> type, String dsql, Object... params) {
		return getDao().queryUnique(type, dsql, params);
	}

	@Override
	public <T> T queryUnique(Class<T> type, String dsql, Map<String, Object> params) {
		return getDao().queryUnique(type, dsql, params);
	}

	@Override
	public Page<Object[]> page(String dsql, long currentPage, int pageSize, Object... params) {
		return getDao().page(dsql, currentPage, pageSize, params);
	}

	@Override
	public Page<Object[]> page(String dsql, long currentPage, int pageSize, Map<String, Object> params) {
		return getDao().page(dsql, currentPage, pageSize, params);
	}

	@Override
	public <T extends Serializable> Page<T> page(Class<T> type, String dsql, long currentPage, int pageSize,
			Object... params) {
		return getDao().page(type, dsql, currentPage, pageSize, params);
	}

	@Override
	public <T extends Serializable> Page<T> page(Class<T> type, String dsql, long currentPage, int pageSize,
			Map<String, Object> params) {
		return getDao().page(type, dsql, currentPage, pageSize, params);
	}

	@Override
	public P update(P p) {
		return getDao().update(p);
	}

	@Override
	public P saveOrUpdate(P p) {
		return getDao().saveOrUpdate(p);
	}

	@Override
	public boolean delete(P p) {
		return getDao().delete(p);
	}

	@Override
	public int delete(Serializable id) {
		return getDao().delete(entityClass, id);
	}

	@Override
	public boolean insertBatch(List<P> list, int size) {
		return getDao().insertBatch(list, size);
	}

	@Override
	public boolean updateBatch(List<P> list, int size) {
		return getDao().updateBatch(list, size);
	}

	@Override
	public boolean saveOrUpdateBatch(List<P> list, int size) {
		return getDao().saveOrUpdateBatch(list, size);
	}

	@Override
	public int excecute(String dsql, Object... params) {
		return getDao().excecute(dsql, params);
	}

	@Override
	public int excecute(String dsql, Map<String, Object> params) {
		return getDao().excecute(dsql, params);
	}

}
