package cn.tenmg.hibernate.sqltool.interceptor;

import java.io.Serializable;
import java.util.Date;

import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

/**
 * 实体拦截器
 * 
 * @author 赵伟均 wjzhao@aliyun.com
 *
 */
public class EntityInterceptor extends EmptyInterceptor {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8721496072630858102L;

	private String createUserFieldName = "createUser";

	private String createTimeFieldName = "createTime";

	private String modifyUserFieldName = "modifyUser";

	private String modifyTimeFieldName = "modifyTime";

	private boolean updateModifyWhenCreate = true;

	private CurrentUserGetter currentUserGetter = new EmptyCurrentUserGetter();

	public String getCreateUserFieldName() {
		return createUserFieldName;
	}

	public void setCreateUserFieldName(String createUserFieldName) {
		this.createUserFieldName = createUserFieldName;
	}

	public String getCreateTimeFieldName() {
		return createTimeFieldName;
	}

	public void setCreateTimeFieldName(String createTimeFieldName) {
		this.createTimeFieldName = createTimeFieldName;
	}

	public String getModifyUserFieldName() {
		return modifyUserFieldName;
	}

	public void setModifyUserFieldName(String modifyUserFieldName) {
		this.modifyUserFieldName = modifyUserFieldName;
	}

	public String getModifyTimeFieldName() {
		return modifyTimeFieldName;
	}

	public void setModifyTimeFieldName(String modifyTimeFieldName) {
		this.modifyTimeFieldName = modifyTimeFieldName;
	}

	public CurrentUserGetter getCurrentUserGetter() {
		return currentUserGetter;
	}

	public void setCurrentUserGetter(CurrentUserGetter currentUserGetter) {
		this.currentUserGetter = currentUserGetter;
	}

	public boolean isUpdateModifyWhenCreate() {
		return updateModifyWhenCreate;
	}

	public void setUpdateModifyWhenCreate(boolean updateModifyWhenCreate) {
		this.updateModifyWhenCreate = updateModifyWhenCreate;
	}

	/**
	 * 插入脏数据时调用该方法
	 */
	@Override
	public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState,
			String[] propertyNames, Type[] types) {
		boolean changed = false;
		Serializable curUser = currentUserGetter.getCurrentUser();
		for (int i = 0; i < propertyNames.length; i++) {
			if (modifyUserFieldName.equals(propertyNames[i]) && curUser != null) {
				currentState[i] = curUser;
				changed = true;
			} else if (modifyTimeFieldName.equals(propertyNames[i])) {
				currentState[i] = new Date();
				changed = true;
			}
		}
		return changed;

	}

	/**
	 * 保存对象时调用该方法
	 */
	@Override
	public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
		boolean changed = false;
		Serializable curUser = currentUserGetter.getCurrentUser();
		for (int i = 0; i < propertyNames.length; i++) {
			if (createUserFieldName.equals(propertyNames[i]) && curUser != null) {
				state[i] = curUser;
				changed = true;
			} else if (createTimeFieldName.equals(propertyNames[i]) && state[i] == null) {
				state[i] = new Date();
				changed = true;
			}
			if (this.isUpdateModifyWhenCreate()) {
				if (modifyUserFieldName.equals(propertyNames[i]) && curUser != null) {
					state[i] = curUser;
					changed = true;
				} else if (modifyTimeFieldName.equals(propertyNames[i])) {
					state[i] = new Date();
					changed = true;
				}
			}
		}
		return changed;
	}

	/**
	 * 当前用户获取器
	 * 
	 * @author 赵伟均 wjzhao@aliyun.com
	 *
	 */
	public interface CurrentUserGetter {
		public Serializable getCurrentUser();
	}

	/**
	 * 空的当前用户获取器，也是默认的当前用户获取器
	 * 
	 * @author 赵伟均 wjzhao@aliyun.com
	 *
	 */
	public class EmptyCurrentUserGetter implements CurrentUserGetter {

		@Override
		public Serializable getCurrentUser() {
			return null;
		}

	}
}
