/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.token.delegation;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

@InterfaceStability.Evolving
public class TokenInformation {
    private KafkaPrincipal owner;
    private Collection<KafkaPrincipal> renewers;
    private long issueTimestamp;
    private long maxTimestamp;
    private long expiryTimestamp;
    private String tokenId;

    public TokenInformation(String tokenId, KafkaPrincipal owner, Collection<KafkaPrincipal> renewers, long issueTimestamp, long maxTimestamp, long expiryTimestamp) {
        this.tokenId = tokenId;
        this.owner = owner;
        this.renewers = renewers;
        this.issueTimestamp = issueTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.expiryTimestamp = expiryTimestamp;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public String ownerAsString() {
        return this.owner.toString();
    }

    public Collection<KafkaPrincipal> renewers() {
        return this.renewers;
    }

    public Collection<String> renewersAsString() {
        ArrayList<String> renewerList = new ArrayList<String>();
        for (KafkaPrincipal renewer : this.renewers) {
            renewerList.add(renewer.toString());
        }
        return renewerList;
    }

    public long issueTimestamp() {
        return this.issueTimestamp;
    }

    public long expiryTimestamp() {
        return this.expiryTimestamp;
    }

    public void setExpiryTimestamp(long expiryTimestamp) {
        this.expiryTimestamp = expiryTimestamp;
    }

    public String tokenId() {
        return this.tokenId;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public boolean ownerOrRenewer(KafkaPrincipal principal) {
        return this.owner.equals(principal) || this.renewers.contains(principal);
    }

    public String toString() {
        return "TokenInformation{owner=" + this.owner + ", renewers=" + this.renewers + ", issueTimestamp=" + this.issueTimestamp + ", maxTimestamp=" + this.maxTimestamp + ", expiryTimestamp=" + this.expiryTimestamp + ", tokenId='" + this.tokenId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenInformation that = (TokenInformation)o;
        return this.issueTimestamp == that.issueTimestamp && this.maxTimestamp == that.maxTimestamp && Objects.equals(this.owner, that.owner) && Objects.equals(this.renewers, that.renewers) && Objects.equals(this.tokenId, that.tokenId);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + (this.renewers != null ? this.renewers.hashCode() : 0);
        result = 31 * result + Long.hashCode(this.issueTimestamp);
        result = 31 * result + Long.hashCode(this.maxTimestamp);
        result = 31 * result + (this.tokenId != null ? this.tokenId.hashCode() : 0);
        return result;
    }
}

