/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.SecurityUtils;
import java.security.Principal;
import java.util.Objects;

public class KafkaPrincipal
implements Principal {
    public static final String USER_TYPE = "User";
    public static final KafkaPrincipal ANONYMOUS = new KafkaPrincipal("User", "ANONYMOUS");
    private final String principalType;
    private final String name;
    private volatile boolean tokenAuthenticated;

    public KafkaPrincipal(String principalType, String name) {
        this.principalType = Objects.requireNonNull(principalType, "Principal type cannot be null");
        this.name = Objects.requireNonNull(name, "Principal name cannot be null");
    }

    @Deprecated
    public static KafkaPrincipal fromString(String str) {
        return SecurityUtils.parseKafkaPrincipal(str);
    }

    @Override
    public String toString() {
        return this.principalType + ":" + this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        KafkaPrincipal that = (KafkaPrincipal)o;
        return this.principalType.equals(that.principalType) && this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        int result = this.principalType != null ? this.principalType.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPrincipalType() {
        return this.principalType;
    }

    public void tokenAuthenticated(boolean tokenAuthenticated) {
        this.tokenAuthenticated = tokenAuthenticated;
    }

    public boolean tokenAuthenticated() {
        return this.tokenAuthenticated;
    }
}

