/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.BoundField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.SchemaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.BaseRecords;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public class Struct {
    private final Schema schema;
    private final Object[] values;

    Struct(Schema schema, Object[] values) {
        this.schema = schema;
        this.values = values;
    }

    public Struct(Schema schema) {
        this.schema = schema;
        this.values = new Object[this.schema.numFields()];
    }

    public Schema schema() {
        return this.schema;
    }

    private Object getFieldOrDefault(BoundField field) {
        Object value = this.values[field.index];
        if (value != null) {
            return value;
        }
        if (field.def.hasDefaultValue) {
            return field.def.defaultValue;
        }
        if (field.def.type.isNullable()) {
            return null;
        }
        throw new SchemaException("Missing value for field '" + field.def.name + "' which has no default value.");
    }

    public Object get(BoundField field) {
        this.validateField(field);
        return this.getFieldOrDefault(field);
    }

    public Byte get(Field.Int8 field) {
        return this.getByte(field.name);
    }

    public Integer get(Field.Int32 field) {
        return this.getInt(field.name);
    }

    public Long get(Field.Int64 field) {
        return this.getLong(field.name);
    }

    public UUID get(Field.UUID field) {
        return this.getUUID(field.name);
    }

    public Short get(Field.Int16 field) {
        return this.getShort(field.name);
    }

    public Double get(Field.Float64 field) {
        return this.getDouble(field.name);
    }

    public String get(Field.Str field) {
        return this.getString(field.name);
    }

    public String get(Field.NullableStr field) {
        return this.getString(field.name);
    }

    public Boolean get(Field.Bool field) {
        return this.getBoolean(field.name);
    }

    public Object[] get(Field.Array field) {
        return this.getArray(field.name);
    }

    public Object[] get(Field.ComplexArray field) {
        return this.getArray(field.name);
    }

    public Long getOrElse(Field.Int64 field, long alternative) {
        if (this.hasField(field.name)) {
            return this.getLong(field.name);
        }
        return alternative;
    }

    public UUID getOrElse(Field.UUID field, UUID alternative) {
        if (this.hasField(field.name)) {
            return this.getUUID(field.name);
        }
        return alternative;
    }

    public Short getOrElse(Field.Int16 field, short alternative) {
        if (this.hasField(field.name)) {
            return this.getShort(field.name);
        }
        return alternative;
    }

    public Byte getOrElse(Field.Int8 field, byte alternative) {
        if (this.hasField(field.name)) {
            return this.getByte(field.name);
        }
        return alternative;
    }

    public Integer getOrElse(Field.Int32 field, int alternative) {
        if (this.hasField(field.name)) {
            return this.getInt(field.name);
        }
        return alternative;
    }

    public Double getOrElse(Field.Float64 field, double alternative) {
        if (this.hasField(field.name)) {
            return this.getDouble(field.name);
        }
        return alternative;
    }

    public String getOrElse(Field.NullableStr field, String alternative) {
        if (this.hasField(field.name)) {
            return this.getString(field.name);
        }
        return alternative;
    }

    public String getOrElse(Field.Str field, String alternative) {
        if (this.hasField(field.name)) {
            return this.getString(field.name);
        }
        return alternative;
    }

    public boolean getOrElse(Field.Bool field, boolean alternative) {
        if (this.hasField(field.name)) {
            return this.getBoolean(field.name);
        }
        return alternative;
    }

    public Object[] getOrEmpty(Field.Array field) {
        if (this.hasField(field.name)) {
            return this.getArray(field.name);
        }
        return new Object[0];
    }

    public Object[] getOrEmpty(Field.ComplexArray field) {
        if (this.hasField(field.name)) {
            return this.getArray(field.name);
        }
        return new Object[0];
    }

    public Object get(String name) {
        BoundField field = this.schema.get(name);
        if (field == null) {
            throw new SchemaException("No such field: " + name);
        }
        return this.getFieldOrDefault(field);
    }

    public boolean hasField(String name) {
        return this.schema.get(name) != null;
    }

    public boolean hasField(Field def) {
        return this.schema.get(def.name) != null;
    }

    public boolean hasField(Field.ComplexArray def) {
        return this.schema.get(def.name) != null;
    }

    public Struct getStruct(BoundField field) {
        return (Struct)this.get(field);
    }

    public Struct getStruct(String name) {
        return (Struct)this.get(name);
    }

    public Byte getByte(BoundField field) {
        return (Byte)this.get(field);
    }

    public byte getByte(String name) {
        return (Byte)this.get(name);
    }

    public BaseRecords getRecords(String name) {
        return (BaseRecords)this.get(name);
    }

    public Short getShort(BoundField field) {
        return (Short)this.get(field);
    }

    public Short getShort(String name) {
        return (Short)this.get(name);
    }

    public Integer getInt(BoundField field) {
        return (Integer)this.get(field);
    }

    public Integer getInt(String name) {
        return (Integer)this.get(name);
    }

    public Long getUnsignedInt(String name) {
        return (Long)this.get(name);
    }

    public Long getLong(BoundField field) {
        return (Long)this.get(field);
    }

    public Long getLong(String name) {
        return (Long)this.get(name);
    }

    public UUID getUUID(BoundField field) {
        return (UUID)this.get(field);
    }

    public UUID getUUID(String name) {
        return (UUID)this.get(name);
    }

    public Double getDouble(BoundField field) {
        return (Double)this.get(field);
    }

    public Double getDouble(String name) {
        return (Double)this.get(name);
    }

    public Object[] getArray(BoundField field) {
        return (Object[])this.get(field);
    }

    public Object[] getArray(String name) {
        return (Object[])this.get(name);
    }

    public String getString(BoundField field) {
        return (String)this.get(field);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public Boolean getBoolean(BoundField field) {
        return (Boolean)this.get(field);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    public ByteBuffer getBytes(BoundField field) {
        Object result = this.get(field);
        if (result instanceof byte[]) {
            return ByteBuffer.wrap((byte[])result);
        }
        return (ByteBuffer)result;
    }

    public ByteBuffer getBytes(String name) {
        Object result = this.get(name);
        if (result instanceof byte[]) {
            return ByteBuffer.wrap((byte[])result);
        }
        return (ByteBuffer)result;
    }

    public byte[] getByteArray(String name) {
        Object result = this.get(name);
        if (result instanceof byte[]) {
            return (byte[])result;
        }
        ByteBuffer buf = (ByteBuffer)result;
        byte[] arr = new byte[buf.remaining()];
        buf.get(arr);
        buf.flip();
        return arr;
    }

    public Struct set(BoundField field, Object value) {
        this.validateField(field);
        this.values[field.index] = value;
        return this;
    }

    public Struct set(String name, Object value) {
        BoundField field = this.schema.get(name);
        if (field == null) {
            throw new SchemaException("Unknown field: " + name);
        }
        this.values[field.index] = value;
        return this;
    }

    public Struct set(Field.Str def, String value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.NullableStr def, String value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Int8 def, byte value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Int32 def, int value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Int64 def, long value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.UUID def, UUID value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Int16 def, short value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Float64 def, double value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Bool def, boolean value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.Array def, Object[] value) {
        return this.set(def.name, (Object)value);
    }

    public Struct set(Field.ComplexArray def, Object[] value) {
        return this.set(def.name, (Object)value);
    }

    public Struct setByteArray(String name, byte[] value) {
        ByteBuffer buf = value == null ? null : ByteBuffer.wrap(value);
        return this.set(name, (Object)buf);
    }

    public Struct setIfExists(Field.Array def, Object[] value) {
        return this.setIfExists(def.name, (Object)value);
    }

    public Struct setIfExists(Field.ComplexArray def, Object[] value) {
        return this.setIfExists(def.name, (Object)value);
    }

    public Struct setIfExists(Field def, Object value) {
        return this.setIfExists(def.name, value);
    }

    public Struct setIfExists(String fieldName, Object value) {
        BoundField field = this.schema.get(fieldName);
        if (field != null) {
            this.values[field.index] = value;
        }
        return this;
    }

    public Struct instance(BoundField field) {
        this.validateField(field);
        if (field.def.type instanceof Schema) {
            return new Struct((Schema)field.def.type);
        }
        if (field.def.type.isArray()) {
            return new Struct((Schema)field.def.type.arrayElementType().get());
        }
        throw new SchemaException("Field '" + field.def.name + "' is not a container type, it is of type " + field.def.type);
    }

    public Struct instance(String field) {
        return this.instance(this.schema.get(field));
    }

    public Struct instance(Field field) {
        return this.instance(this.schema.get(field.name));
    }

    public Struct instance(Field.ComplexArray field) {
        return this.instance(this.schema.get(field.name));
    }

    public void clear() {
        Arrays.fill(this.values, null);
    }

    public int sizeOf() {
        return this.schema.sizeOf(this);
    }

    public void writeTo(ByteBuffer buffer) {
        this.schema.write(buffer, this);
    }

    private void validateField(BoundField field) {
        Objects.requireNonNull(field, "`field` must be non-null");
        if (this.schema != field.schema) {
            throw new SchemaException("Attempt to access field '" + field.def.name + "' from a different schema instance.");
        }
        if (field.index > this.values.length) {
            throw new SchemaException("Invalid field index: " + field.index);
        }
    }

    public void validate() {
        this.schema.validate(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.values.length; ++i) {
            BoundField f = this.schema.get(i);
            b.append(f.def.name);
            b.append('=');
            if (f.def.type.isArray() && this.values[i] != null) {
                Object[] arrayValue = (Object[])this.values[i];
                b.append('[');
                for (int j = 0; j < arrayValue.length; ++j) {
                    b.append(arrayValue[j]);
                    if (j >= arrayValue.length - 1) continue;
                    b.append(',');
                }
                b.append(']');
            } else {
                b.append(this.values[i]);
            }
            if (i >= this.values.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (int i = 0; i < this.values.length; ++i) {
            BoundField f = this.schema.get(i);
            if (f.def.type.isArray()) {
                Object[] arrayObject;
                if (this.get(f) == null) continue;
                for (Object arrayItem : arrayObject = (Object[])this.get(f)) {
                    result = 31 * result + arrayItem.hashCode();
                }
                continue;
            }
            Object field = this.get(f);
            if (field == null) continue;
            result = 31 * result + field.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Struct other = (Struct)obj;
        if (this.schema != other.schema) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            boolean result;
            BoundField f = this.schema.get(i);
            if (f.def.type.isArray()) {
                result = Arrays.equals((Object[])this.get(f), (Object[])other.get(f));
            } else {
                Object thisField = this.get(f);
                Object otherField = other.get(f);
                result = Objects.equals(thisField, otherField);
            }
            if (result) continue;
            return false;
        }
        return true;
    }
}

