/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.InvalidTopicException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.util.Collections;
import java.util.Set;

public class Topic {
    public static final String GROUP_METADATA_TOPIC_NAME = "__consumer_offsets";
    public static final String TRANSACTION_STATE_TOPIC_NAME = "__transaction_state";
    public static final String LEGAL_CHARS = "[a-zA-Z0-9._-]";
    private static final Set<String> INTERNAL_TOPICS = Collections.unmodifiableSet(Utils.mkSet("__consumer_offsets", "__transaction_state"));
    private static final int MAX_NAME_LENGTH = 249;

    public static void validate(String topic) {
        if (topic.isEmpty()) {
            throw new InvalidTopicException("Topic name is illegal, it can't be empty");
        }
        if (topic.equals(".") || topic.equals("..")) {
            throw new InvalidTopicException("Topic name cannot be \".\" or \"..\"");
        }
        if (topic.length() > 249) {
            throw new InvalidTopicException("Topic name is illegal, it can't be longer than 249 characters, topic name: " + topic);
        }
        if (!Topic.containsValidPattern(topic)) {
            throw new InvalidTopicException("Topic name \"" + topic + "\" is illegal, it contains a character other than ASCII alphanumerics, '.', '_' and '-'");
        }
    }

    public static boolean isInternal(String topic) {
        return INTERNAL_TOPICS.contains(topic);
    }

    public static boolean hasCollisionChars(String topic) {
        return topic.contains("_") || topic.contains(".");
    }

    public static boolean hasCollision(String topicA, String topicB) {
        return topicA.replace('.', '_').equals(topicB.replace('.', '_'));
    }

    static boolean containsValidPattern(String topic) {
        for (int i = 0; i < topic.length(); ++i) {
            boolean validChar;
            char c = topic.charAt(i);
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

