/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Cluster;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.ClusterResource;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Node;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.PartitionInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.MetadataResponse;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MetadataCache {
    private final String clusterId;
    private final Map<Integer, Node> nodes;
    private final Set<String> unauthorizedTopics;
    private final Set<String> invalidTopics;
    private final Set<String> internalTopics;
    private final Node controller;
    private final Map<TopicPartition, MetadataResponse.PartitionMetadata> metadataByPartition;
    private Cluster clusterInstance;

    MetadataCache(String clusterId, Map<Integer, Node> nodes, Collection<MetadataResponse.PartitionMetadata> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller) {
        this(clusterId, nodes, partitions, unauthorizedTopics, invalidTopics, internalTopics, controller, null);
    }

    private MetadataCache(String clusterId, Map<Integer, Node> nodes, Collection<MetadataResponse.PartitionMetadata> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller, Cluster clusterInstance) {
        this.clusterId = clusterId;
        this.nodes = nodes;
        this.unauthorizedTopics = unauthorizedTopics;
        this.invalidTopics = invalidTopics;
        this.internalTopics = internalTopics;
        this.controller = controller;
        this.metadataByPartition = new HashMap<TopicPartition, MetadataResponse.PartitionMetadata>(partitions.size());
        for (MetadataResponse.PartitionMetadata p : partitions) {
            this.metadataByPartition.put(p.topicPartition, p);
        }
        if (clusterInstance == null) {
            this.computeClusterView();
        } else {
            this.clusterInstance = clusterInstance;
        }
    }

    Optional<MetadataResponse.PartitionMetadata> partitionMetadata(TopicPartition topicPartition) {
        return Optional.ofNullable(this.metadataByPartition.get(topicPartition));
    }

    Optional<Node> nodeById(int id) {
        return Optional.ofNullable(this.nodes.get(id));
    }

    Cluster cluster() {
        if (this.clusterInstance == null) {
            throw new IllegalStateException("Cached Cluster instance should not be null, but was.");
        }
        return this.clusterInstance;
    }

    ClusterResource clusterResource() {
        return new ClusterResource(this.clusterId);
    }

    MetadataCache mergeWith(String newClusterId, Map<Integer, Node> newNodes, Collection<MetadataResponse.PartitionMetadata> addPartitions, Set<String> addUnauthorizedTopics, Set<String> addInvalidTopics, Set<String> addInternalTopics, Node newController, BiPredicate<String, Boolean> retainTopic) {
        Predicate<String> shouldRetainTopic = topic -> retainTopic.test((String)topic, this.internalTopics.contains(topic));
        HashMap<TopicPartition, MetadataResponse.PartitionMetadata> newMetadataByPartition = new HashMap<TopicPartition, MetadataResponse.PartitionMetadata>(addPartitions.size());
        for (MetadataResponse.PartitionMetadata partitionMetadata : addPartitions) {
            newMetadataByPartition.put(partitionMetadata.topicPartition, partitionMetadata);
        }
        for (Map.Entry entry : this.metadataByPartition.entrySet()) {
            if (!shouldRetainTopic.test(((TopicPartition)entry.getKey()).topic())) continue;
            newMetadataByPartition.putIfAbsent((TopicPartition)entry.getKey(), (MetadataResponse.PartitionMetadata)entry.getValue());
        }
        Set<String> newUnauthorizedTopics = MetadataCache.fillSet(addUnauthorizedTopics, this.unauthorizedTopics, shouldRetainTopic);
        Set<String> set = MetadataCache.fillSet(addInvalidTopics, this.invalidTopics, shouldRetainTopic);
        Set<String> newInternalTopics = MetadataCache.fillSet(addInternalTopics, this.internalTopics, shouldRetainTopic);
        return new MetadataCache(newClusterId, newNodes, newMetadataByPartition.values(), newUnauthorizedTopics, set, newInternalTopics, newController);
    }

    private static <T> Set<T> fillSet(Set<T> baseSet, Set<T> fillSet, Predicate<T> predicate) {
        HashSet<T> result = new HashSet<T>(baseSet);
        for (T element : fillSet) {
            if (!predicate.test(element)) continue;
            result.add(element);
        }
        return result;
    }

    private void computeClusterView() {
        List<PartitionInfo> partitionInfos = this.metadataByPartition.values().stream().map(metadata -> MetadataResponse.toPartitionInfo(metadata, this.nodes)).collect(Collectors.toList());
        this.clusterInstance = new Cluster(this.clusterId, this.nodes.values(), partitionInfos, this.unauthorizedTopics, this.invalidTopics, this.internalTopics, this.controller);
    }

    static MetadataCache bootstrap(List<InetSocketAddress> addresses) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        int nodeId = -1;
        for (InetSocketAddress address : addresses) {
            nodes.put(nodeId, new Node(nodeId, address.getHostString(), address.getPort()));
            --nodeId;
        }
        return new MetadataCache(null, nodes, Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Cluster.bootstrap(addresses));
    }

    static MetadataCache empty() {
        return new MetadataCache(null, Collections.emptyMap(), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Cluster.empty());
    }

    public String toString() {
        return "MetadataCache{clusterId='" + this.clusterId + '\'' + ", nodes=" + this.nodes + ", partitions=" + this.metadataByPartition.values() + ", controller=" + this.controller + '}';
    }
}

