/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.cdc.log.debezium.history;

import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.Value;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class FlinkJsonTableChangeSerializer
implements TableChanges.TableChangesSerializer<Array> {
    @Override
    public Array serialize(TableChanges tableChanges) {
        List<Value> values = StreamSupport.stream(tableChanges.spliterator(), false).map(this::toDocument).map(Value::create).collect(Collectors.toList());
        return Array.create(values);
    }

    public Document toDocument(TableChanges.TableChange tableChange) {
        Document document = Document.create();
        document.setString("type", tableChange.getType().name());
        document.setString("id", tableChange.getId().toDoubleQuotedString());
        document.setDocument("table", this.toDocument(tableChange.getTable()));
        return document;
    }

    private Document toDocument(Table table) {
        Document document = Document.create();
        document.set("defaultCharsetName", table.defaultCharsetName());
        document.set("primaryKeyColumnNames", Array.create(table.primaryKeyColumnNames()));
        List columns = table.columns().stream().map(this::toDocument).collect(Collectors.toList());
        document.setArray((CharSequence)"columns", Array.create(columns));
        return document;
    }

    private Document toDocument(Column column) {
        Document document = Document.create();
        document.setString("name", column.name());
        document.setNumber((CharSequence)"jdbcType", column.jdbcType());
        if (column.nativeType() != -1) {
            document.setNumber((CharSequence)"nativeType", column.nativeType());
        }
        document.setString("typeName", column.typeName());
        document.setString("typeExpression", column.typeExpression());
        document.setString("charsetName", column.charsetName());
        if (column.length() != -1) {
            document.setNumber((CharSequence)"length", column.length());
        }
        column.scale().ifPresent(s -> document.setNumber((CharSequence)"scale", (int)s));
        document.setNumber((CharSequence)"position", column.position());
        document.setBoolean("optional", column.isOptional());
        document.setBoolean("autoIncremented", column.isAutoIncremented());
        document.setBoolean("generated", column.isGenerated());
        document.setArray((CharSequence)"enumValues", column.enumValues().toArray());
        return document;
    }

    @Override
    public TableChanges deserialize(Array array, boolean useCatalogBeforeSchema) {
        TableChanges tableChanges = new TableChanges();
        for (Array.Entry entry : array) {
            TableChanges.TableChange change = FlinkJsonTableChangeSerializer.fromDocument(entry.getValue().asDocument(), useCatalogBeforeSchema);
            if (change.getType() == TableChanges.TableChangeType.CREATE) {
                tableChanges.create(change.getTable());
                continue;
            }
            if (change.getType() == TableChanges.TableChangeType.ALTER) {
                tableChanges.alter(change.getTable());
                continue;
            }
            if (change.getType() != TableChanges.TableChangeType.DROP) continue;
            tableChanges.drop(change.getTable());
        }
        return tableChanges;
    }

    private static Table fromDocument(TableId id, Document document) {
        TableEditor editor = Table.editor().tableId(id).setDefaultCharsetName(document.getString("defaultCharsetName"));
        document.getArray("columns").streamValues().map(Value::asDocument).map(v -> {
            Integer scale;
            ColumnEditor columnEditor = Column.editor().name(v.getString("name")).jdbcType(v.getInteger("jdbcType"));
            Integer nativeType = v.getInteger("nativeType");
            if (nativeType != null) {
                columnEditor.nativeType(nativeType);
            }
            columnEditor.type(v.getString("typeName"), v.getString("typeExpression")).charsetName(v.getString("charsetName"));
            Integer length = v.getInteger("length");
            if (length != null) {
                columnEditor.length(length);
            }
            if ((scale = v.getInteger("scale")) != null) {
                columnEditor.scale(scale);
            }
            columnEditor.position(v.getInteger("position")).optional(v.getBoolean("optional")).autoIncremented(v.getBoolean("autoIncremented")).generated(v.getBoolean("generated"));
            Array enumValues = v.getArray("enumValues");
            if (enumValues != null && !enumValues.isEmpty()) {
                columnEditor.enumValues(enumValues.streamValues().map(Value::asString).collect(Collectors.toList()));
            }
            return columnEditor.create();
        }).forEach(editor::addColumn);
        editor.setPrimaryKeyNames(document.getArray("primaryKeyColumnNames").streamValues().map(Value::asString).collect(Collectors.toList()));
        return editor.create();
    }

    public static TableChanges.TableChange fromDocument(Document document, boolean useCatalogBeforeSchema) {
        TableChanges.TableChangeType type = TableChanges.TableChangeType.valueOf(document.getString("type"));
        TableId id = TableId.parse(document.getString("id"), useCatalogBeforeSchema);
        Table table = null;
        table = type == TableChanges.TableChangeType.CREATE || type == TableChanges.TableChangeType.ALTER ? FlinkJsonTableChangeSerializer.fromDocument(id, document.getDocument("table")) : Table.editor().tableId(id).create();
        return new TableChanges.TableChange(type, table);
    }
}

