/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.cdc.log.connectors.sqlserver.table;

import cn.tenmg.cdc.log.connectors.sqlserver.SqlServerSource;
import cn.tenmg.cdc.log.connectors.sqlserver.table.SqlServerDeserializationConverterFactory;
import cn.tenmg.cdc.log.connectors.sqlserver.table.SqlServerReadableMetadata;
import cn.tenmg.cdc.log.connectors.sqlserver.table.StartupOptions;
import cn.tenmg.cdc.log.debezium.DebeziumSourceFunction;
import cn.tenmg.cdc.log.debezium.table.MetadataConverter;
import cn.tenmg.cdc.log.debezium.table.RowDataDebeziumDeserializeSchema;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class SqlServerTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    private final int port;
    private final String hostname;
    private final String database;
    private final String schemaName;
    private final String tableName;
    private final ZoneId serverTimeZone;
    private final String username;
    private final String password;
    private final Properties dbzProperties;
    private final StartupOptions startupOptions;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public SqlServerTableSource(ResolvedSchema physicalSchema, int port, String hostname, String database, String schemaName, String tableName, ZoneId serverTimeZone, String username, String password, Properties dbzProperties, StartupOptions startupOptions) {
        this.physicalSchema = physicalSchema;
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.serverTimeZone = serverTimeZone;
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.dbzProperties = dbzProperties;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
        this.startupOptions = startupOptions;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setMetadataConverters(metadataConverters).setResultTypeInfo((TypeInformation<RowData>)typeInfo).setServerTimeZone(this.serverTimeZone).setUserDefinedConverterFactory(SqlServerDeserializationConverterFactory.instance()).build();
        DebeziumSourceFunction<RowData> sourceFunction = SqlServerSource.builder().hostname(this.hostname).port(this.port).database(this.database).tableList(this.schemaName + "." + this.tableName).username(this.username).password(this.password).debeziumProperties(this.dbzProperties).startupOptions(this.startupOptions).deserializer(deserializer).build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    private MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(SqlServerReadableMetadata.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(SqlServerReadableMetadata::getConverter).toArray(MetadataConverter[]::new);
    }

    public DynamicTableSource copy() {
        SqlServerTableSource source = new SqlServerTableSource(this.physicalSchema, this.port, this.hostname, this.database, this.schemaName, this.tableName, this.serverTimeZone, this.username, this.password, this.dbzProperties, this.startupOptions);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlServerTableSource that = (SqlServerTableSource)o;
        return this.port == that.port && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.database, that.database) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.serverTimeZone, that.serverTimeZone) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.dbzProperties, that.dbzProperties) && Objects.equals(this.startupOptions, that.startupOptions) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.port, this.hostname, this.database, this.schemaName, this.tableName, this.serverTimeZone, this.username, this.password, this.dbzProperties, this.startupOptions, this.producedDataType, this.metadataKeys);
    }

    public String asSummaryString() {
        return "SqlServer-CDC";
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(SqlServerReadableMetadata.values()).collect(Collectors.toMap(SqlServerReadableMetadata::getKey, SqlServerReadableMetadata::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }
}

