/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Histogram {
    private final int[] counts;
    private final Logger log = LoggerFactory.getLogger(Histogram.class);

    public Histogram(int maxValue) {
        this.counts = new int[maxValue + 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int value) {
        if (value < 0) {
            throw new RuntimeException("invalid negative value.");
        }
        if (value >= this.counts.length) {
            value = this.counts.length - 1;
        }
        Histogram histogram = this;
        synchronized (histogram) {
            int curCount = this.counts[value];
            if (curCount < Integer.MAX_VALUE) {
                this.counts[value] = this.counts[value] + 1;
            }
        }
    }

    public void add(long value) {
        if (value > Integer.MAX_VALUE) {
            this.add(Integer.MAX_VALUE);
        } else if (value < Integer.MIN_VALUE) {
            this.add(Integer.MIN_VALUE);
        } else {
            this.add((int)value);
        }
    }

    public Summary summarize() {
        return this.summarize(new float[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Summary summarize(float[] percentiles) {
        int[] countsCopy = new int[this.counts.length];
        Histogram histogram = this;
        synchronized (histogram) {
            System.arraycopy(this.counts, 0, countsCopy, 0, this.counts.length);
        }
        float prev = 0.0f;
        for (int i = 0; i < percentiles.length; ++i) {
            if (percentiles[i] < prev) {
                throw new RuntimeException("Invalid percentiles fraction array.  Bad element " + percentiles[i] + ".  The array must be sorted and non-negative.");
            }
            if (!(percentiles[i] > 1.0f)) continue;
            throw new RuntimeException("Invalid percentiles fraction array.  Bad element " + percentiles[i] + ".  Elements must be less than or equal to 1.");
        }
        long numSamples = 0L;
        float total = 0.0f;
        for (int i = 0; i < countsCopy.length; ++i) {
            long count = countsCopy[i];
            numSamples += count;
            total += (float)((long)i * count);
        }
        float average = numSamples == 0L ? 0.0f : total / (float)numSamples;
        List<PercentileSummary> percentileSummaries = this.summarizePercentiles(countsCopy, percentiles, numSamples);
        return new Summary(numSamples, average, percentileSummaries);
    }

    private List<PercentileSummary> summarizePercentiles(int[] countsCopy, float[] percentiles, long numSamples) {
        if (percentiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PercentileSummary> summaries = new ArrayList<PercentileSummary>(percentiles.length);
        int i = 0;
        int j = 0;
        long seen = 0L;
        long next = (long)((float)numSamples * percentiles[0]);
        while (true) {
            if (i == countsCopy.length - 1) {
                while (j < percentiles.length) {
                    summaries.add(new PercentileSummary(percentiles[j], i));
                    ++j;
                }
                return summaries;
            }
            seen += (long)countsCopy[i];
            while (seen >= next) {
                summaries.add(new PercentileSummary(percentiles[j], i));
                if (++j == percentiles.length) {
                    return summaries;
                }
                next = (long)((float)numSamples * percentiles[j]);
            }
            ++i;
        }
    }

    public static class PercentileSummary {
        private final float fraction;
        private final int value;

        PercentileSummary(float fraction, int value) {
            this.fraction = fraction;
            this.value = value;
        }

        public float fraction() {
            return this.fraction;
        }

        public int value() {
            return this.value;
        }
    }

    public static class Summary {
        private final long numSamples;
        private final float average;
        private final List<PercentileSummary> percentiles;

        Summary(long numSamples, float average, List<PercentileSummary> percentiles) {
            this.numSamples = numSamples;
            this.average = average;
            this.percentiles = percentiles;
        }

        public long numSamples() {
            return this.numSamples;
        }

        public float average() {
            return this.average;
        }

        public List<PercentileSummary> percentiles() {
            return this.percentiles;
        }
    }
}

