/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.cdc.log.connectors.postgres.table;

import cn.tenmg.cdc.log.connectors.postgres.PostgreSQLSource;
import cn.tenmg.cdc.log.connectors.postgres.table.PostgreSQLReadableMetadata;
import cn.tenmg.cdc.log.connectors.postgres.table.PostgresValueValidator;
import cn.tenmg.cdc.log.debezium.DebeziumSourceFunction;
import cn.tenmg.cdc.log.debezium.table.MetadataConverter;
import cn.tenmg.cdc.log.debezium.table.RowDataDebeziumDeserializeSchema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class PostgreSQLTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    private final int port;
    private final String hostname;
    private final String database;
    private final String schemaName;
    private final String tableName;
    private final String username;
    private final String password;
    private final String pluginName;
    private final String slotName;
    private final Properties dbzProperties;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public PostgreSQLTableSource(ResolvedSchema physicalSchema, int port, String hostname, String database, String schemaName, String tableName, String username, String password, String pluginName, String slotName, Properties dbzProperties) {
        this.physicalSchema = physicalSchema;
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.pluginName = (String)Preconditions.checkNotNull((Object)pluginName);
        this.slotName = slotName;
        this.dbzProperties = dbzProperties;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setMetadataConverters(metadataConverters).setResultTypeInfo((TypeInformation<RowData>)typeInfo).setValueValidator(new PostgresValueValidator(this.schemaName, this.tableName)).build();
        DebeziumSourceFunction<RowData> sourceFunction = PostgreSQLSource.builder().hostname(this.hostname).port(this.port).database(this.database).schemaList(this.schemaName).tableList(this.schemaName + "." + this.tableName).username(this.username).password(this.password).decodingPluginName(this.pluginName).slotName(this.slotName).debeziumProperties(this.dbzProperties).deserializer(deserializer).build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    private MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(PostgreSQLReadableMetadata.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(PostgreSQLReadableMetadata::getConverter).toArray(MetadataConverter[]::new);
    }

    public DynamicTableSource copy() {
        PostgreSQLTableSource source = new PostgreSQLTableSource(this.physicalSchema, this.port, this.hostname, this.database, this.schemaName, this.tableName, this.username, this.password, this.pluginName, this.slotName, this.dbzProperties);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostgreSQLTableSource that = (PostgreSQLTableSource)o;
        return this.port == that.port && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.database, that.database) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.pluginName, that.pluginName) && Objects.equals(this.slotName, that.slotName) && Objects.equals(this.dbzProperties, that.dbzProperties) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.port, this.hostname, this.database, this.schemaName, this.tableName, this.username, this.password, this.pluginName, this.slotName, this.dbzProperties, this.producedDataType, this.metadataKeys);
    }

    public String asSummaryString() {
        return "PostgreSQL-CDC";
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(PostgreSQLReadableMetadata.values()).collect(Collectors.toMap(PostgreSQLReadableMetadata::getKey, PostgreSQLReadableMetadata::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }
}

