/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator;

import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.parser.JDBCParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.model.Jdbc;
import cn.tenmg.flink.jobs.operator.AbstractOperator;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import cn.tenmg.flink.jobs.utils.JSONUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcOperator
extends AbstractOperator<Jdbc> {
    private static Logger log = LoggerFactory.getLogger(JdbcOperator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(StreamExecutionEnvironment env, Jdbc jdbc, Map<String, Object> params) throws Exception {
        NamedScript namedScript = DSLUtils.parse((String)jdbc.getScript(), params);
        String datasource = jdbc.getDataSource();
        String script = namedScript.getScript();
        Map usedParams = namedScript.getParams();
        Script sql = DSLUtils.toScript((String)script, (Map)usedParams, (ParamsParser)JDBCParamsParser.getInstance());
        if (StringUtils.isNotBlank((String)datasource)) {
            PreparedStatement ps;
            Connection con;
            block8: {
                String method;
                block7: {
                    block6: {
                        Long l;
                        Map<String, String> dataSource = FlinkJobsContext.getDatasource(datasource);
                        con = null;
                        ps = null;
                        try {
                            con = JDBCUtils.getConnection(dataSource);
                            con.setAutoCommit(true);
                            String statement = sql.getValue();
                            ps = con.prepareStatement(statement);
                            List paramters = (List)sql.getParams();
                            JDBCUtils.setParams(ps, paramters);
                            log.info(String.format("Execute JDBC SQL: %s; parameters: %s", script, JSONUtils.toJSONString(usedParams)));
                            method = jdbc.getMethod();
                            if (!"executeLargeUpdate".equals(method)) break block6;
                            l = ps.executeLargeUpdate();
                        }
                        catch (Throwable throwable) {
                            JDBCUtils.close(ps);
                            JDBCUtils.close(con);
                            throw throwable;
                        }
                        JDBCUtils.close(ps);
                        JDBCUtils.close(con);
                        return l;
                    }
                    if (!"executeUpdate".equals(method)) break block7;
                    Integer n = ps.executeUpdate();
                    JDBCUtils.close(ps);
                    JDBCUtils.close(con);
                    return n;
                }
                if (!"execute".equals(method)) break block8;
                Boolean bl = ps.execute();
                JDBCUtils.close(ps);
                JDBCUtils.close(con);
                return bl;
            }
            Long l = ps.executeLargeUpdate();
            JDBCUtils.close(ps);
            JDBCUtils.close(con);
            return l;
        }
        throw new IllegalArgumentException("dataSource must be not null");
    }
}

