/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.flink.jobs.parser.FlinkSQLParamsParser;
import java.util.Iterator;
import java.util.Map;

public abstract class SQLUtils {
    public static final String SINGLE_QUOTATION_MARK = "'";
    public static final String SPACE_EQUALS_SPACE = " = ";

    public static String toSQL(NamedScript namedScript) {
        return SQLUtils.toSQL(namedScript.getScript(), namedScript.getParams());
    }

    public static String toSQL(String namedscript, Map<String, ?> params) {
        return DSLUtils.toScript((String)namedscript, params, (ParamsParser)FlinkSQLParamsParser.getInstance()).getValue();
    }

    public static void appendDataSource(StringBuffer sqlBuffer, Map<String, String> dataSource) {
        Iterator<Map.Entry<String, String>> it = dataSource.entrySet().iterator();
        Map.Entry<String, String> entry = it.next();
        SQLUtils.appendProperty(sqlBuffer, entry);
        while (it.hasNext()) {
            entry = it.next();
            sqlBuffer.append(',').append(' ');
            SQLUtils.appendProperty(sqlBuffer, entry);
        }
    }

    public static String wrapString(String value) {
        return SINGLE_QUOTATION_MARK + value.replaceAll(SINGLE_QUOTATION_MARK, "\\\\'") + SINGLE_QUOTATION_MARK;
    }

    public static void apppendEquals(StringBuffer sqlBuffer) {
        sqlBuffer.append(SPACE_EQUALS_SPACE);
    }

    private static void appendProperty(StringBuffer sqlBuffer, Map.Entry<String, String> entry) {
        sqlBuffer.append(SQLUtils.wrapKey(entry.getKey()));
        SQLUtils.apppendEquals(sqlBuffer);
        sqlBuffer.append(SQLUtils.wrapValue(entry.getValue()));
    }

    private static String wrapKey(String value) {
        return SQLUtils.isString(value) ? value : SQLUtils.wrapString(value);
    }

    private static boolean isString(String value) {
        return value.startsWith(SINGLE_QUOTATION_MARK) && value.endsWith(SINGLE_QUOTATION_MARK);
    }

    private static String wrapValue(String value) {
        if (value == null) {
            return "null";
        }
        if (SQLUtils.isString(value)) {
            return value;
        }
        return SQLUtils.wrapString(value);
    }
}

