/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator;

import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.parser.JDBCParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.model.Jdbc;
import cn.tenmg.flink.jobs.operator.AbstractOperator;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import cn.tenmg.flink.jobs.utils.JSONUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcOperator
extends AbstractOperator<Jdbc> {
    private static Logger log = LoggerFactory.getLogger(JdbcOperator.class);

    @Override
    public Object execute(StreamExecutionEnvironment env, Jdbc jdbc, Map<String, Object> params) throws Exception {
        NamedScript namedScript = DSLUtils.parse((String)jdbc.getScript(), params);
        String datasource = jdbc.getDataSource();
        Script sql = DSLUtils.toScript((String)namedScript.getScript(), (Map)namedScript.getParams(), (ParamsParser)JDBCParamsParser.getInstance());
        if (StringUtils.isNotBlank((String)datasource)) {
            Long l;
            PreparedStatement ps;
            Connection con;
            block10: {
                String method;
                block9: {
                    block8: {
                        Map<String, String> dataSource = FlinkJobsContext.getDatasource(datasource);
                        con = null;
                        ps = null;
                        con = JDBCUtils.getConnection(dataSource);
                        con.setAutoCommit(true);
                        String statement = sql.getValue();
                        ps = con.prepareStatement(statement);
                        List paramters = (List)sql.getParams();
                        JDBCUtils.setParams(ps, paramters);
                        log.info(String.format("Execute JDBC SQL: %s; parameters: %s", statement, JSONUtils.toJSONString(params)));
                        method = jdbc.getMethod();
                        if (!"executeLargeUpdate".equals(method)) break block8;
                        Long l2 = ps.executeLargeUpdate();
                        JDBCUtils.close(ps);
                        JDBCUtils.close(con);
                        return l2;
                    }
                    if (!"executeUpdate".equals(method)) break block9;
                    Integer n = ps.executeUpdate();
                    JDBCUtils.close(ps);
                    JDBCUtils.close(con);
                    return n;
                }
                if (!"execute".equals(method)) break block10;
                Boolean bl = ps.execute();
                JDBCUtils.close(ps);
                JDBCUtils.close(con);
                return bl;
            }
            try {
                l = ps.executeLargeUpdate();
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(ps);
                    JDBCUtils.close(con);
                    throw throwable;
                }
            }
            JDBCUtils.close(ps);
            JDBCUtils.close(con);
            return l;
        }
        throw new IllegalArgumentException("dataSource must be not null");
    }
}

