/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.utils;

import cn.tenmg.dsl.utils.ParamsUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.utils.ObjectUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PlaceHolderUtils {
    private static final Pattern paramPattern = Pattern.compile("\\$\\{[^}]+\\}");
    private static final Pattern arrayPattern = Pattern.compile("\\[[^\\]]+\\]");

    public static String replace(String tpl, CharSequence ... params) {
        if (params != null && params.length > 1) {
            HashMap<CharSequence, CharSequence> map = new HashMap<CharSequence, CharSequence>();
            for (int i = 0; i < params.length; i += 2) {
                map.put(params[i], params[i + 1]);
            }
            return PlaceHolderUtils.replace(tpl, map);
        }
        return tpl;
    }

    public static String replace(String tpl, Map<?, ?> params) {
        if (StringUtils.isBlank((String)tpl)) {
            return tpl;
        }
        if (params == null || params.isEmpty()) {
            return tpl;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = paramPattern.matcher(tpl);
        while (m.find()) {
            String name = m.group();
            Object value = ParamsUtils.getParam(params, (String)name.substring(2, name.length() - 1));
            if (value == null) {
                m.appendReplacement(sb, "");
                continue;
            }
            m.appendReplacement(sb, value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Deprecated
    public static Object getParam(Map<?, ?> params, String name) {
        Object value = params.get(name);
        if (value == null) {
            if (name.contains(".")) {
                String[] names = name.split("\\.");
                value = params.get(name = names[0]);
                if (value == null) {
                    return PlaceHolderUtils.getMaybeArrayOrMapValue(params, name);
                }
                for (int i = 1; i < names.length; ++i) {
                    name = names[i];
                    if ((value = ObjectUtils.getValue(value, name)) != null) continue;
                    Matcher m = arrayPattern.matcher(name);
                    if (m.find()) {
                        if ((value = ObjectUtils.getValue(value, name.substring(0, name.indexOf("[")))) == null) {
                            return null;
                        }
                        value = PlaceHolderUtils.getArrayOrMapValue(value, params, m);
                    }
                    return value;
                }
                return value;
            }
            return PlaceHolderUtils.getMaybeArrayOrMapValue(params, name);
        }
        return value;
    }

    @Deprecated
    private static final Object getMaybeArrayOrMapValue(Map<?, ?> params, String name) {
        Object value = null;
        Matcher m = arrayPattern.matcher(name);
        if (m.find()) {
            value = params.get(name.substring(0, name.indexOf("[")));
            if (value == null) {
                return null;
            }
            value = PlaceHolderUtils.getArrayOrMapValue(value, params, m);
        }
        return value;
    }

    @Deprecated
    private static final Object getArrayOrMapValue(Object value, Map<?, ?> params, Matcher m) {
        value = PlaceHolderUtils.getArrayOrMapValue(value, params, m.group());
        while (value != null && m.find()) {
            value = PlaceHolderUtils.getArrayOrMapValue(value, params, m.group());
        }
        return value;
    }

    @Deprecated
    private static final Object getArrayOrMapValue(Object value, Map<?, ?> params, String group) {
        String name = group.substring(1, group.length() - 1);
        return PlaceHolderUtils.getValue(value, params, name);
    }

    private static final Object getValue(Object value, Map<?, ?> params, String name) {
        Object v = params.get(name);
        String real = name;
        if (v != null) {
            real = v.toString();
        }
        if (value instanceof Map) {
            return ((Map)value).get(real);
        }
        if (value instanceof List) {
            return ((List)value).get(Integer.valueOf(real));
        }
        if (value instanceof Object[]) {
            return ((Object[])value)[Integer.valueOf(real)];
        }
        if (value instanceof LinkedHashSet) {
            return ((LinkedHashSet)value).toArray()[Integer.valueOf(real)];
        }
        return null;
    }
}

