/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator.data.sync.getter;

import cn.tenmg.flink.jobs.operator.data.sync.MetaDataGetter;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractJDBCMetaDataGetter
implements MetaDataGetter {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String NO = "NO";

    abstract Connection getConnection(Map<String, String> var1) throws Exception;

    @Override
    public MetaDataGetter.TableMetaData getTableMetaData(Map<String, String> dataSource, String tableName) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection(dataSource);
            con.setAutoCommit(true);
            DatabaseMetaData metaData = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = con.getSchema();
            ResultSet primaryKeysSet = metaData.getPrimaryKeys(catalog, schema, tableName);
            HashSet<String> primaryKeys = new HashSet<String>();
            while (primaryKeysSet.next()) {
                primaryKeys.add(primaryKeysSet.getString(COLUMN_NAME));
            }
            ResultSet columnsSet = metaData.getColumns(catalog, schema, tableName, null);
            LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
            while (columnsSet.next()) {
                String columnName = columnsSet.getString(COLUMN_NAME);
                int dataType = columnsSet.getInt(DATA_TYPE);
                String type = AbstractJDBCMetaDataGetter.getType(dataType, columnsSet);
                if (NO.equals(columnsSet.getString(IS_NULLABLE))) {
                    type = type + " NOT NULL";
                }
                columns.put(columnName, type);
            }
            MetaDataGetter.TableMetaData tableMetaData = new MetaDataGetter.TableMetaData(primaryKeys, columns);
            return tableMetaData;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            JDBCUtils.close(con);
        }
    }

    private static String getType(int dataType, ResultSet columnsSet) throws SQLException {
        switch (dataType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return "STRING";
            }
            case -5: {
                return "BIGINT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -7: {
                if (columnsSet.getInt(COLUMN_SIZE) == 1) {
                    return "BOOLEAN";
                }
                return "TINYINT";
            }
            case 3: {
                return "DECIMAL(" + columnsSet.getInt(COLUMN_SIZE) + "," + columnsSet.getInt(DECIMAL_DIGITS) + ")";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: 
            case 7: {
                return "FLOAT";
            }
            case 4: {
                return "INT";
            }
            case 2: {
                return "NUMERIC(" + columnsSet.getInt(COLUMN_SIZE) + "," + columnsSet.getInt(DECIMAL_DIGITS) + ")";
            }
            case 5: {
                return "SMALLINT";
            }
            case -6: {
                return "TINYINT";
            }
            case 91: {
                return "DATE";
            }
            case 92: 
            case 2013: {
                int columnSize = columnsSet.getInt(COLUMN_SIZE);
                if (columnSize > 8) {
                    return "TIME(" + (columnSize - 9) + ")";
                }
                return "TIME";
            }
            case 93: 
            case 2014: {
                int columnSize = columnsSet.getInt(COLUMN_SIZE);
                if (columnSize > 19) {
                    return "TIMESTAMP(" + (columnSize - 20) + ")";
                }
                return "TIMESTAMP";
            }
            case -4: 
            case -3: 
            case -2: {
                return "BYTES";
            }
            case 2006: {
                return "REF";
            }
            case 70: {
                return "DATALINK";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: 
            case 2011: {
                return "CLOB";
            }
            case 2002: {
                return "STRUCT";
            }
        }
        return "STRING";
    }
}

