/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator;

import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.model.SqlQuery;
import cn.tenmg.flink.jobs.operator.AbstractSqlOperator;
import cn.tenmg.flink.jobs.utils.SQLUtils;
import java.util.Map;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public class SqlQueryOperator
extends AbstractSqlOperator<SqlQuery> {
    @Override
    Object execute(StreamTableEnvironment tableEnv, SqlQuery sqlQuery, Map<String, Object> params) throws Exception {
        NamedScript namedScript = DSLUtils.parse((String)sqlQuery.getScript(), params);
        String saveAs = sqlQuery.getSaveAs();
        String statement = SQLUtils.toSQL(namedScript);
        System.out.println("Execute query by Flink SQL: " + statement);
        Table table = tableEnv.sqlQuery(statement);
        String defaultCatalog = FlinkJobsContext.getDefaultCatalog(tableEnv);
        if (!defaultCatalog.equals(tableEnv.getCurrentCatalog())) {
            tableEnv.useCatalog(defaultCatalog);
        }
        tableEnv.createTemporaryView(saveAs, table);
        return table;
    }
}

