/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator;

import cn.tenmg.dsl.NamedScript;
import cn.tenmg.dsl.ParamsParser;
import cn.tenmg.dsl.Script;
import cn.tenmg.dsl.parser.JDBCParamsParser;
import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.model.ExecuteSql;
import cn.tenmg.flink.jobs.operator.AbstractSqlOperator;
import cn.tenmg.flink.jobs.utils.ConfigurationUtils;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import cn.tenmg.flink.jobs.utils.JSONUtils;
import cn.tenmg.flink.jobs.utils.MapUtils;
import cn.tenmg.flink.jobs.utils.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public class ExecuteSqlOperator
extends AbstractSqlOperator<ExecuteSql> {
    private static final String TABLE_NAME = "table-name";
    private static final String DELETE_CLAUSE_REGEX = "[\\s]*[D|d][E|e][L|l][E|e][T|t][E|e][\\s]+[F|f][R|r][O|o][M|m][\\s]+[\\S]+";
    private static final String UPDATE_CLAUSE_REGEX = "[\\s]*[U|u][P|p][D|d][A|a][T|t][E|e][\\s]+[\\S]+[\\s]+[S|s][E|e][T|t][\\s]+[\\S]+";
    private static final Pattern WITH_CLAUSE_PATTERN = Pattern.compile("[W|w][I|i][T|t][H|h][\\s]*\\([\\s\\S]*\\)[\\s]*$");
    private static final Pattern CREATE_CLAUSE_PATTERN = Pattern.compile("[C|c][R|r][E|e][A|a][T|t][E|e][\\s]+[T|t][A|a][B|b][L|l][E|e][\\s]+[\\S]+");

    @Override
    Object execute(StreamTableEnvironment tableEnv, ExecuteSql sql, Map<String, Object> params) throws Exception {
        NamedScript namedScript = DSLUtils.parse((String)sql.getScript(), params);
        String datasource = sql.getDataSource();
        String statement = namedScript.getScript();
        if (StringUtils.isNotBlank((String)datasource)) {
            Map<String, String> dataSource = FlinkJobsContext.getDatasource(datasource);
            if (ConfigurationUtils.isJDBC(dataSource) && (statement.matches(DELETE_CLAUSE_REGEX) || statement.matches(UPDATE_CLAUSE_REGEX))) {
                Long l;
                Script script = DSLUtils.toScript((String)namedScript.getScript(), (Map)namedScript.getParams(), (ParamsParser)JDBCParamsParser.getInstance());
                statement = script.getValue();
                Connection con = null;
                PreparedStatement ps = null;
                try {
                    con = JDBCUtils.getConnection(dataSource);
                    con.setAutoCommit(true);
                    ps = con.prepareStatement(statement);
                    List parameters = (List)script.getParams();
                    JDBCUtils.setParams(ps, parameters);
                    System.out.println(String.format("Execute JDBC SQL: %s; parameters: %s", statement, JSONUtils.toJSONString(parameters)));
                    l = ps.executeLargeUpdate();
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        JDBCUtils.close(ps);
                        JDBCUtils.close(con);
                        throw throwable;
                    }
                }
                JDBCUtils.close(ps);
                JDBCUtils.close(con);
                return l;
            }
            statement = SQLUtils.toSQL(namedScript);
            statement = ExecuteSqlOperator.wrapDataSource(statement, dataSource);
        }
        System.out.println("Execute Flink SQL: " + statement);
        return tableEnv.executeSql(statement);
    }

    private static String wrapDataSource(String script, Map<String, String> dataSource) throws IOException {
        Matcher matcher = WITH_CLAUSE_PATTERN.matcher(script);
        StringBuffer sqlBuffer = new StringBuffer();
        if (matcher.find()) {
            String group = matcher.group();
            int startIndex = group.indexOf("(") + 1;
            int endIndex = group.lastIndexOf(")");
            String start = group.substring(0, startIndex);
            String value = group.substring(startIndex, endIndex);
            String end = group.substring(endIndex);
            if (StringUtils.isBlank((String)value)) {
                matcher.appendReplacement(sqlBuffer, start);
                SQLUtils.appendDataSource(sqlBuffer, dataSource);
                if (!dataSource.containsKey(TABLE_NAME)) {
                    ExecuteSqlOperator.apppendDefaultTableName(sqlBuffer, script);
                }
                sqlBuffer.append(end);
            } else {
                char c;
                int i;
                Map<String, String> config = ConfigurationUtils.load(value);
                HashMap<String, String> actualDataSource = MapUtils.newHashMap(dataSource);
                MapUtils.removeAll(actualDataSource, config.keySet());
                matcher.appendReplacement(sqlBuffer, start);
                StringBuilder blank = new StringBuilder();
                int len = value.length();
                for (i = len - 1; i > 0 && (c = value.charAt(i)) <= ' '; --i) {
                    blank.append(c);
                }
                sqlBuffer.append(value.substring(0, i + 1)).append(',').append(' ');
                SQLUtils.appendDataSource(sqlBuffer, actualDataSource);
                if (ConfigurationUtils.isJDBC(actualDataSource) && !config.containsKey(TABLE_NAME) && !actualDataSource.containsKey(TABLE_NAME)) {
                    ExecuteSqlOperator.apppendDefaultTableName(sqlBuffer, script);
                }
                sqlBuffer.append((CharSequence)blank.reverse()).append(end);
            }
        } else {
            sqlBuffer.append(script);
            sqlBuffer.append(" WITH (");
            SQLUtils.appendDataSource(sqlBuffer, dataSource);
            if (!dataSource.containsKey(TABLE_NAME)) {
                ExecuteSqlOperator.apppendDefaultTableName(sqlBuffer, script);
            }
            sqlBuffer.append(")");
        }
        return sqlBuffer.toString();
    }

    private static void apppendDefaultTableName(StringBuffer sqlBuffer, String script) {
        Matcher createMatcher = CREATE_CLAUSE_PATTERN.matcher(script);
        if (createMatcher.find()) {
            char c;
            String group = createMatcher.group();
            StringBuilder tableNameBuilder = new StringBuilder();
            int i = group.length();
            while (--i > 0) {
                c = group.charAt(i);
                if (c <= ' ') continue;
                tableNameBuilder.append(c);
                break;
            }
            while (--i > 0 && (c = group.charAt(i)) > ' ') {
                tableNameBuilder.append(c);
            }
            sqlBuffer.append(',').append(' ').append(SQLUtils.wrapString(TABLE_NAME));
            SQLUtils.apppendEquals(sqlBuffer);
            sqlBuffer.append(SQLUtils.wrapString(tableNameBuilder.reverse().toString()));
        }
    }
}

