/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.operator;

import cn.tenmg.flink.jobs.Operator;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.model.SqlQuery;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public abstract class AbstractSqlOperator<T extends SqlQuery>
implements Operator {
    protected Class<T> type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public void execute(StreamExecutionEnvironment env, String config, Map<String, Object> params) throws Exception {
        StreamTableEnvironment tableEnv = FlinkJobsContext.getOrCreateStreamTableEnvironment(env);
        SqlQuery operate = (SqlQuery)JSON.parseObject((String)config, this.type);
        String catalog = operate.getCatalog();
        String currentCatalog = tableEnv.getCurrentCatalog();
        String saveAs = operate.getSaveAs();
        if (catalog == null) {
            String defaultCatalog = FlinkJobsContext.getDefaultCatalog(tableEnv);
            if (!defaultCatalog.equals(currentCatalog)) {
                tableEnv.useCatalog(defaultCatalog);
            }
        } else if (!catalog.equals(currentCatalog)) {
            tableEnv.useCatalog(catalog);
        }
        if (saveAs == null) {
            this.execute(tableEnv, (SqlQuery)JSON.parseObject((String)config, this.type), params);
        } else {
            params.put(saveAs, this.execute(tableEnv, (SqlQuery)JSON.parseObject((String)config, this.type), params));
        }
    }

    abstract Object execute(StreamTableEnvironment var1, T var2, Map<String, Object> var3) throws Exception;
}

