/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs;

import cn.tenmg.flink.jobs.StreamService;
import cn.tenmg.flink.jobs.model.Params;
import com.alibaba.fastjson.JSON;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

public abstract class FlinkJobsRunner {
    protected abstract String getDefaultService();

    protected abstract RuntimeExecutionMode getDefaultRuntimeMode();

    protected abstract StreamService getStreamService(String var1);

    public void run(String ... args) throws Exception {
        Params params;
        String serviceName = null;
        if (args == null || args.length <= 0) {
            params = new Params();
        } else {
            params = (Params)JSON.parseObject((String)args[0], Params.class);
            serviceName = params.getServiceName();
        }
        if (serviceName == null) {
            serviceName = this.getDefaultService();
            params.setServiceName(serviceName);
        }
        if (params.getRuntimeMode() == null) {
            params.setRuntimeMode(this.getDefaultRuntimeMode());
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        RuntimeExecutionMode mode = params.getRuntimeMode();
        if (RuntimeExecutionMode.BATCH.equals((Object)mode)) {
            env.setRuntimeMode(RuntimeExecutionMode.BATCH);
        } else if (RuntimeExecutionMode.STREAMING.equals((Object)mode)) {
            env.setRuntimeMode(RuntimeExecutionMode.STREAMING);
        }
        this.getStreamService(serviceName).run(env, params);
        env.execute();
    }
}

