/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.launcher.context;

import cn.tenmg.flink.jobs.launcher.utils.PropertiesLoaderUtils;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlinkJobsLauncherContext {
    private static final Logger log = LoggerFactory.getLogger(FlinkJobsLauncherContext.class);
    private static final String DEFAULT_STRATEGIES_PATH = "flink-jobs-launcher-context-loader.properties";
    private static final String CONFIG_LOCATION_KEY = "config.location";
    private static Properties configProperties;

    public static String getConfigLocation() {
        return FlinkJobsLauncherContext.getProperty(CONFIG_LOCATION_KEY);
    }

    public static Properties getConfigProperties() {
        return configProperties;
    }

    public static String getProperty(String key) {
        return configProperties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return configProperties.containsKey(key) ? configProperties.getProperty(key) : defaultValue;
    }

    static {
        try {
            configProperties = PropertiesLoaderUtils.loadFromClassPath(DEFAULT_STRATEGIES_PATH);
        }
        catch (Exception e) {
            log.warn("flink-jobs-launcher-context-loader.properties not found in the classpath.", (Throwable)e);
            configProperties = new Properties();
        }
        String configurationFile = configProperties.getProperty(CONFIG_LOCATION_KEY, "flink-jobs-launcher.properties");
        try {
            configProperties.putAll((Map<?, ?>)PropertiesLoaderUtils.loadFromClassPath(configurationFile));
        }
        catch (Exception e) {
            log.info("Configuration file " + configurationFile + " not found in classpath, the default configuration will be used.");
        }
    }
}

