/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.launcher.context;

import cn.tenmg.flink.jobs.launcher.utils.PropertiesLoaderUtils;
import java.util.Properties;

public abstract class FlinkJobsLauncherContext {
    private static final String DEFAULT_STRATEGIES_PATH = "flink-jobs-launcher-context-loader.properties";
    private static final String CONFIG_LOCATION_KEY = "config.location";
    private static Properties defaultProperties;
    private static Properties configProperties;

    public static String getConfigLocation() {
        return FlinkJobsLauncherContext.getProperty(CONFIG_LOCATION_KEY);
    }

    public static String getProperty(String key) {
        return configProperties.containsKey(key) ? configProperties.getProperty(key) : defaultProperties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return configProperties.containsKey(key) ? configProperties.getProperty(key) : (defaultProperties.containsKey(key) ? defaultProperties.getProperty(key) : defaultValue);
    }

    static {
        try {
            defaultProperties = PropertiesLoaderUtils.loadFromClassPath(DEFAULT_STRATEGIES_PATH);
        }
        catch (Exception e) {
            defaultProperties = new Properties();
        }
        try {
            String configLocation = defaultProperties.getProperty(CONFIG_LOCATION_KEY, "flink-jobs-launcher.properties");
            configProperties = PropertiesLoaderUtils.loadFromClassPath(configLocation);
        }
        catch (Exception e) {
            configProperties = new Properties();
        }
    }
}

