/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.launcher;

import cn.tenmg.flink.jobs.FlinkJobsLauncher;
import cn.tenmg.flink.jobs.config.model.FlinkJobs;
import cn.tenmg.flink.jobs.launcher.AbstractFlinkJobsLauncher;
import cn.tenmg.flink.jobs.launcher.context.FlinkJobsLauncherContext;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public class RestClusterClientFlinkJobsLauncher
extends AbstractFlinkJobsLauncher {
    private static final Configuration configuration = new Configuration();
    private volatile RestClusterClient<StandaloneClusterId> restClusterClient;

    public RestClusterClientFlinkJobsLauncher() {
        RestClusterClientFlinkJobsLauncher.setConfigString(configuration, (ConfigOption<String>)JobManagerOptions.ADDRESS);
        RestClusterClientFlinkJobsLauncher.setConfigString(configuration, (ConfigOption<String>)JobManagerOptions.ARCHIVE_DIR);
        RestClusterClientFlinkJobsLauncher.setConfigString(configuration, (ConfigOption<String>)JobManagerOptions.BIND_HOST);
        RestClusterClientFlinkJobsLauncher.setConfigString(configuration, (ConfigOption<String>)JobManagerOptions.EXECUTION_FAILOVER_STRATEGY);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)JobManagerOptions.JOB_STORE_MAX_CAPACITY);
        RestClusterClientFlinkJobsLauncher.setConfigLong(configuration, (ConfigOption<Long>)JobManagerOptions.JOB_STORE_CACHE_SIZE);
        RestClusterClientFlinkJobsLauncher.setConfigLong(configuration, (ConfigOption<Long>)JobManagerOptions.JOB_STORE_EXPIRATION_TIME);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)JobManagerOptions.JOB_STORE_MAX_CAPACITY);
        RestClusterClientFlinkJobsLauncher.setConfigBoolean(configuration, (ConfigOption<Boolean>)JobManagerOptions.JVM_DIRECT_MEMORY_LIMIT_ENABLED);
        RestClusterClientFlinkJobsLauncher.setConfigMemorySize(configuration, (ConfigOption<MemorySize>)JobManagerOptions.JVM_HEAP_MEMORY);
        RestClusterClientFlinkJobsLauncher.setConfigMemorySize(configuration, (ConfigOption<MemorySize>)JobManagerOptions.JVM_METASPACE);
        RestClusterClientFlinkJobsLauncher.setConfigFloat(configuration, (ConfigOption<Float>)JobManagerOptions.JVM_OVERHEAD_FRACTION);
        RestClusterClientFlinkJobsLauncher.setConfigMemorySize(configuration, (ConfigOption<MemorySize>)JobManagerOptions.JVM_OVERHEAD_MAX);
        RestClusterClientFlinkJobsLauncher.setConfigMemorySize(configuration, (ConfigOption<MemorySize>)JobManagerOptions.JVM_OVERHEAD_MIN);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)JobManagerOptions.MAX_ATTEMPTS_HISTORY_SIZE);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)JobManagerOptions.MIN_PARALLELISM_INCREASE);
        RestClusterClientFlinkJobsLauncher.setConfigMemorySize(configuration, (ConfigOption<MemorySize>)JobManagerOptions.OFF_HEAP_MEMORY);
        RestClusterClientFlinkJobsLauncher.setConfigBoolean(configuration, (ConfigOption<Boolean>)JobManagerOptions.PARTITION_RELEASE_DURING_JOB_EXECUTION);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)JobManagerOptions.PORT);
        RestClusterClientFlinkJobsLauncher.setConfigDuration(configuration, (ConfigOption<Duration>)JobManagerOptions.RESOURCE_STABILIZATION_TIMEOUT);
        RestClusterClientFlinkJobsLauncher.setConfigDuration(configuration, (ConfigOption<Duration>)JobManagerOptions.RESOURCE_WAIT_TIMEOUT);
        RestClusterClientFlinkJobsLauncher.setConfigBoolean(configuration, (ConfigOption<Boolean>)JobManagerOptions.RETRIEVE_TASK_MANAGER_HOSTNAME);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)JobManagerOptions.RPC_BIND_PORT);
        RestClusterClientFlinkJobsLauncher.setConfigSchedulerType(configuration, (ConfigOption<JobManagerOptions.SchedulerType>)JobManagerOptions.SCHEDULER);
        RestClusterClientFlinkJobsLauncher.setConfigSchedulerExecutionMode(configuration, (ConfigOption<SchedulerExecutionMode>)JobManagerOptions.SCHEDULER_MODE);
        RestClusterClientFlinkJobsLauncher.setConfigLong(configuration, (ConfigOption<Long>)JobManagerOptions.SLOT_IDLE_TIMEOUT);
        RestClusterClientFlinkJobsLauncher.setConfigLong(configuration, (ConfigOption<Long>)JobManagerOptions.SLOT_REQUEST_TIMEOUT);
        RestClusterClientFlinkJobsLauncher.setConfigMemorySize(configuration, (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_FLINK_MEMORY);
        RestClusterClientFlinkJobsLauncher.setConfigMemorySize(configuration, (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_PROCESS_MEMORY);
        RestClusterClientFlinkJobsLauncher.setConfigString(configuration, (ConfigOption<String>)RestOptions.ADDRESS);
        RestClusterClientFlinkJobsLauncher.setConfigLong(configuration, (ConfigOption<Long>)RestOptions.AWAIT_LEADER_TIMEOUT);
        RestClusterClientFlinkJobsLauncher.setConfigString(configuration, (ConfigOption<String>)RestOptions.BIND_ADDRESS);
        RestClusterClientFlinkJobsLauncher.setConfigString(configuration, (ConfigOption<String>)RestOptions.BIND_PORT);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)RestOptions.CLIENT_MAX_CONTENT_LENGTH);
        RestClusterClientFlinkJobsLauncher.setConfigLong(configuration, (ConfigOption<Long>)RestOptions.CONNECTION_TIMEOUT);
        RestClusterClientFlinkJobsLauncher.setConfigBoolean(configuration, (ConfigOption<Boolean>)RestOptions.ENABLE_FLAMEGRAPH);
        RestClusterClientFlinkJobsLauncher.setConfigDuration(configuration, (ConfigOption<Duration>)RestOptions.FLAMEGRAPH_CLEANUP_INTERVAL);
        RestClusterClientFlinkJobsLauncher.setConfigDuration(configuration, (ConfigOption<Duration>)RestOptions.FLAMEGRAPH_DELAY);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)RestOptions.FLAMEGRAPH_NUM_SAMPLES);
        RestClusterClientFlinkJobsLauncher.setConfigDuration(configuration, (ConfigOption<Duration>)RestOptions.FLAMEGRAPH_REFRESH_INTERVAL);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)RestOptions.FLAMEGRAPH_STACK_TRACE_DEPTH);
        RestClusterClientFlinkJobsLauncher.setConfigLong(configuration, (ConfigOption<Long>)RestOptions.IDLENESS_TIMEOUT);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)RestOptions.PORT);
        RestClusterClientFlinkJobsLauncher.setConfigLong(configuration, (ConfigOption<Long>)RestOptions.RETRY_DELAY);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)RestOptions.RETRY_MAX_ATTEMPTS);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)RestOptions.SERVER_MAX_CONTENT_LENGTH);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)RestOptions.SERVER_NUM_THREADS);
        RestClusterClientFlinkJobsLauncher.setConfigInteger(configuration, (ConfigOption<Integer>)RestOptions.SERVER_THREAD_PRIORITY);
    }

    @Override
    public AbstractFlinkJobsLauncher.FlinkJobsInfo launch(FlinkJobs flinkJobs) throws Exception {
        RestClusterClient<StandaloneClusterId> client = null;
        AbstractFlinkJobsLauncher.FlinkJobsInfo appInfo = new AbstractFlinkJobsLauncher.FlinkJobsInfo();
        try {
            client = this.getRestClusterClient();
            File jarFile = new File(RestClusterClientFlinkJobsLauncher.getJar(flinkJobs));
            SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
            PackagedProgram.Builder builder = PackagedProgram.newBuilder().setConfiguration(configuration).setEntryPointClassName(RestClusterClientFlinkJobsLauncher.getEntryPointClassName(flinkJobs)).setJarFile(jarFile).setUserClassPaths(RestClusterClientFlinkJobsLauncher.getUserClassPaths(flinkJobs)).setSavepointRestoreSettings(savepointRestoreSettings);
            String arguments = RestClusterClientFlinkJobsLauncher.getArguments(flinkJobs);
            if (!RestClusterClientFlinkJobsLauncher.isEmptyArguments(arguments).booleanValue()) {
                builder.setArguments(new String[]{arguments});
            }
            PackagedProgram program = builder.build();
            JobGraph jobGraph = PackagedProgramUtils.createJobGraph((PackagedProgram)program, (Configuration)configuration, (int)RestClusterClientFlinkJobsLauncher.getParallelism(flinkJobs), (boolean)Boolean.valueOf(FlinkJobsLauncherContext.getProperty("suppress.output", "false")));
            CompletableFuture submited = client.submitJob(jobGraph);
            JobID jobId = (JobID)submited.get();
            appInfo.setJobId(jobId.toString());
            JobStatus jobStatus = (JobStatus)client.getJobStatus(jobId).get();
            if (JobStatus.INITIALIZING.equals((Object)jobStatus)) {
                appInfo.setState(FlinkJobsLauncher.FlinkJobsInfo.State.ACCEPTED);
            } else if (JobStatus.RUNNING.equals((Object)jobStatus)) {
                appInfo.setState(FlinkJobsLauncher.FlinkJobsInfo.State.RUNNING);
            } else if (JobStatus.FINISHED.equals((Object)jobStatus)) {
                appInfo.setState(FlinkJobsLauncher.FlinkJobsInfo.State.FINISHED);
            } else if (JobStatus.FAILED.equals((Object)jobStatus)) {
                appInfo.setState(FlinkJobsLauncher.FlinkJobsInfo.State.FAILED);
            } else if (JobStatus.CANCELED.equals((Object)jobStatus)) {
                appInfo.setState(FlinkJobsLauncher.FlinkJobsInfo.State.KILLED);
            } else {
                appInfo.setState(FlinkJobsLauncher.FlinkJobsInfo.State.SUBMITTED);
            }
        }
        catch (Exception e) {
            if (client != null) {
                client.close();
            }
            throw e;
        }
        return appInfo;
    }

    @Override
    public String stop(String jobId) throws Exception {
        return (String)this.getRestClusterClient().stopWithSavepoint(JobID.fromHexString((String)jobId), false, FlinkJobsLauncherContext.getProperty("state.savepoints.dir")).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RestClusterClient<StandaloneClusterId> getRestClusterClient() throws Exception {
        if (this.restClusterClient != null) return this.restClusterClient;
        Class<RestClusterClientFlinkJobsLauncher> clazz = RestClusterClientFlinkJobsLauncher.class;
        synchronized (RestClusterClientFlinkJobsLauncher.class) {
            if (this.restClusterClient != null) return this.restClusterClient;
            this.restClusterClient = new RestClusterClient(configuration, (Object)StandaloneClusterId.getInstance());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.restClusterClient;
        }
    }

    private static <T> String getConfigString(ConfigOption<T> configOption) {
        return FlinkJobsLauncherContext.getProperty(configOption.key());
    }

    private static void setConfigString(Configuration configuration, ConfigOption<String> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.setString(configOption, config);
        }
    }

    private static void setConfigInteger(Configuration configuration, ConfigOption<Integer> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.setInteger(configOption, Integer.parseInt(config));
        }
    }

    private static void setConfigLong(Configuration configuration, ConfigOption<Long> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.setLong(configOption, Long.parseLong(config));
        }
    }

    private static void setConfigFloat(Configuration configuration, ConfigOption<Float> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.setFloat(configOption, Float.parseFloat(config));
        }
    }

    private static void setConfigBoolean(Configuration configuration, ConfigOption<Boolean> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.setBoolean(configOption, Boolean.parseBoolean(config));
        }
    }

    private static void setConfigMemorySize(Configuration configuration, ConfigOption<MemorySize> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.set(configOption, (Object)MemorySize.parse((String)config));
        }
    }

    private static void setConfigDuration(Configuration configuration, ConfigOption<Duration> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.set(configOption, (Object)Duration.parse(config));
        }
    }

    private static void setConfigSchedulerType(Configuration configuration, ConfigOption<JobManagerOptions.SchedulerType> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.set(configOption, (Object)JobManagerOptions.SchedulerType.valueOf((String)config));
        }
    }

    private static void setConfigSchedulerExecutionMode(Configuration configuration, ConfigOption<SchedulerExecutionMode> configOption) {
        String config = RestClusterClientFlinkJobsLauncher.getConfigString(configOption);
        if (config != null) {
            configuration.set(configOption, (Object)SchedulerExecutionMode.valueOf((String)config));
        }
    }
}

