/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.launcher;

import cn.tenmg.flink.jobs.FlinkJobsLauncher;
import cn.tenmg.flink.jobs.config.model.FlinkJobs;
import cn.tenmg.flink.jobs.config.model.Options;
import cn.tenmg.flink.jobs.launcher.context.FlinkJobsLauncherContext;
import cn.tenmg.flink.jobs.launcher.utils.Sets;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFlinkJobsLauncher
implements FlinkJobsLauncher {
    private static final String FLINK_JOBS_DEFAULT_JAR_KEY = "flink.jobs.default.jar";
    private static final String FLINK_JOBS_DEFAULT_CLASS_KEY = "flink.jobs.default.class";
    private static final String JAR = ".jar";
    private static final Set<String> EXCLUDES = Sets.as("options", "mainClass", "jar", "allwaysNewJob");
    protected static final String EMPTY_ARGUMENTS = "{}";

    protected static String getJar(FlinkJobs flinkJobs) {
        String jar = flinkJobs.getJar();
        if (jar == null) {
            jar = FlinkJobsLauncherContext.getProperty(FLINK_JOBS_DEFAULT_JAR_KEY);
        }
        if (jar == null) {
            throw new IllegalArgumentException("You must specify the jar to run or configurate by key flink.jobs.default.jar in " + FlinkJobsLauncherContext.getConfigLocation());
        }
        return jar;
    }

    protected static int validateJar(String jar) {
        int jarIndex = jar.lastIndexOf(JAR);
        if (jarIndex <= 0) {
            throw new IllegalArgumentException("The jar file configuration must end with .jar suffix");
        }
        return jarIndex;
    }

    protected static String getEntryPointClassName(FlinkJobs flinkJobs) {
        String mainClass = flinkJobs.getMainClass();
        if (mainClass == null) {
            mainClass = FlinkJobsLauncherContext.getProperty(FLINK_JOBS_DEFAULT_CLASS_KEY);
        }
        return mainClass;
    }

    protected static int getParallelism(FlinkJobs flinkJobs) {
        Options options = flinkJobs.getOptions();
        if (options == null) {
            return AbstractFlinkJobsLauncher.getDefaultParallelism();
        }
        Map option = options.getOption();
        if (option == null) {
            return AbstractFlinkJobsLauncher.getDefaultParallelism();
        }
        String keyPrefix = options.getKeyPrefix();
        String parallelism = "".equals(keyPrefix) ? (option.containsKey("-p") ? (String)option.get("-p") : option.getOrDefault("--parallelism", AbstractFlinkJobsLauncher.getDefaultParallelismString())) : ("-".equals(keyPrefix) ? (option.containsKey("p") ? (String)option.get("p") : option.getOrDefault("-parallelism", AbstractFlinkJobsLauncher.getDefaultParallelismString())) : option.getOrDefault("parallelism", AbstractFlinkJobsLauncher.getDefaultParallelismString()));
        return parallelism == null ? null : Integer.valueOf(Integer.parseInt(parallelism));
    }

    protected static List<URL> getUserClassPaths(FlinkJobs flinkJobs) throws MalformedURLException {
        Options options = flinkJobs.getOptions();
        if (options == null) {
            return AbstractFlinkJobsLauncher.toURLs(AbstractFlinkJobsLauncher.getDefaultUserClassPaths());
        }
        Map option = options.getOption();
        if (option == null) {
            return AbstractFlinkJobsLauncher.toURLs(AbstractFlinkJobsLauncher.getDefaultUserClassPaths());
        }
        String keyPrefix = options.getKeyPrefix();
        String classpaths = "".equals(keyPrefix) ? (option.containsKey("-c") ? (String)option.get("-c") : (String)option.get("--classpaths")) : ("-".equals(keyPrefix) ? (option.containsKey("c") ? (String)option.get("c") : (String)option.get("-classpaths")) : (String)option.get("classpaths"));
        if (classpaths == null || "".equals(classpaths.trim())) {
            classpaths = AbstractFlinkJobsLauncher.getDefaultUserClassPaths();
        }
        return AbstractFlinkJobsLauncher.toURLs(classpaths);
    }

    protected static String getArguments(FlinkJobs flinkJobs) {
        return JSON.toJSONString((Object)flinkJobs, (SerializeFilter)new PropertyFilter(){

            public boolean apply(Object object, String name, Object value) {
                return !EXCLUDES.contains(name);
            }
        }, (SerializerFeature[])new SerializerFeature[0]);
    }

    protected static Boolean isEmptyArguments(String arguments) {
        return arguments == null || EMPTY_ARGUMENTS.equals(arguments) || "".equals(arguments.trim());
    }

    protected static int getDefaultParallelism() {
        return Integer.parseInt(AbstractFlinkJobsLauncher.getDefaultParallelismString());
    }

    private static String getDefaultUserClassPaths() {
        return FlinkJobsLauncherContext.getProperty("classpaths");
    }

    private static String getDefaultParallelismString() {
        return FlinkJobsLauncherContext.getProperty("parallelism.default", "1");
    }

    private static List<URL> toURLs(String classpaths) throws MalformedURLException {
        if (classpaths == null || "".equals(classpaths.trim())) {
            return Collections.emptyList();
        }
        String[] paths = classpaths.contains(";") ? classpaths.split(";") : classpaths.split(",");
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < paths.length; ++i) {
            urls.add(new URL(paths[i].trim()));
        }
        return urls;
    }

    protected static class FlinkJobsInfo
    implements FlinkJobsLauncher.FlinkJobsInfo {
        private String jobId;
        private FlinkJobsLauncher.FlinkJobsInfo.State state;
        private String message;

        protected FlinkJobsInfo() {
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public String getJobId() {
            return this.jobId;
        }

        @Override
        public FlinkJobsLauncher.FlinkJobsInfo.State getState() {
            return this.state;
        }

        public void setState(FlinkJobsLauncher.FlinkJobsInfo.State state) {
            this.state = state;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

