package cn.tenmg.flink.jobs.launcher.config.loader;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.StringReader;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import cn.tenmg.flink.jobs.launcher.config.ConfigLoader;
import cn.tenmg.flink.jobs.launcher.config.model.FlinkJobs;

/**
 * XML配置加载器。config模块已拆分为单独组件flink-jobs-config，并变更包名为cn.tenmg.flink.jobs.config。该类已废弃，请使用flink-jobs-config的类替换。
 * 
 * @author June wjzhao@aliyun.com
 * 
 * @since 1.0.0
 */
@Deprecated
public class XMLConfigLoader implements ConfigLoader {

	private static final XMLConfigLoader INSTANCE = new XMLConfigLoader();

	private XMLConfigLoader() {
		super();
	}

	public static final XMLConfigLoader getInstance() {
		return INSTANCE;
	}

	/**
	 * 加载flink-jobs配置
	 * 
	 * @param s
	 *            配置字符串
	 * @return flink-jobs配置模型
	 */
	public FlinkJobs load(String s) {
		try {
			JAXBContext context = JAXBContext.newInstance(FlinkJobs.class);
			Unmarshaller us = context.createUnmarshaller();
			return (FlinkJobs) us.unmarshal(new StringReader(s));
		} catch (JAXBException e) {
			e.printStackTrace();
			final String msg = "加载flink-jobs配置失败";
			throw new IllegalArgumentException(msg, e);
		}
	}

	/**
	 * 加载flink-jobs配置
	 * 
	 * @param file
	 *            配置文件
	 * @return flink-jobs配置模型
	 */
	public FlinkJobs load(File file) {
		try {
			JAXBContext context = JAXBContext.newInstance(FlinkJobs.class);
			Unmarshaller us = context.createUnmarshaller();
			return (FlinkJobs) us.unmarshal(file);
		} catch (JAXBException e) {
			e.printStackTrace();
			final String msg = "加载flink-jobs配置失败";
			throw new IllegalArgumentException(msg, e);
		}
	}

	/**
	 * 加载flink-jobs配置
	 * 
	 * @param fr
	 *            文件读取器
	 * @return flink-jobs配置模型
	 */
	public FlinkJobs load(FileReader fr) {
		try {
			JAXBContext context = JAXBContext.newInstance(FlinkJobs.class);
			Unmarshaller us = context.createUnmarshaller();
			return (FlinkJobs) us.unmarshal(fr);
		} catch (JAXBException e) {
			e.printStackTrace();
			final String msg = "加载flink-jobs配置失败";
			throw new IllegalArgumentException(msg, e);
		}
	}

	/**
	 * 加载flink-jobs配置
	 * 
	 * @param is
	 *            输入流
	 * @return flink-jobs配置模型
	 */
	@Override
	public FlinkJobs load(InputStream is) {
		try {
			JAXBContext context = JAXBContext.newInstance(FlinkJobs.class);
			Unmarshaller us = context.createUnmarshaller();
			return (FlinkJobs) us.unmarshal(is);
		} catch (JAXBException e) {
			e.printStackTrace();
			final String msg = "加载flink-jobs配置失败";
			throw new IllegalArgumentException(msg, e);
		}
	}
}
