package cn.tenmg.flink.jobs.launcher.config.model;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(namespace = FlinkJobs.NAMESPACE, name = "flink-jobs")
@XmlAccessorType(XmlAccessType.FIELD)
public class FlinkJobs implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2783184277263685612L;

	/**
	 * 可扩展标记语言（XML）模式定义（Schemas Definition）文件的命名空间
	 */
	public static final String NAMESPACE = "http://www.10mg.cn/schema/flink-jobs";

	/**
	 * 运行的JAR包
	 */
	@XmlAttribute
	private String jar;

	/**
	 * 运行的主类
	 */
	@XmlAttribute(name = "class")
	private String mainClass;

	/**
	 * 运行选项
	 */
	@XmlElement(namespace = NAMESPACE)
	private Options options;

	/**
	 * 运行参数
	 */
	@XmlElement(namespace = NAMESPACE)
	private Params params;

	public String getJar() {
		return jar;
	}

	public void setJar(String jar) {
		this.jar = jar;
	}

	public String getMainClass() {
		return mainClass;
	}

	public void setMainClass(String mainClass) {
		this.mainClass = mainClass;
	}

	public Options getOptions() {
		return options;
	}

	public void setOptions(Options options) {
		this.options = options;
	}

	public Params getParams() {
		return params;
	}

	public void setParams(Params params) {
		this.params = params;
	}

}
