/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.launcher;

import cn.tenmg.flink.jobs.FlinkJobsLauncher;
import cn.tenmg.flink.jobs.launcher.config.model.FlinkJobs;
import cn.tenmg.flink.jobs.launcher.config.model.Option;
import cn.tenmg.flink.jobs.launcher.config.model.Options;
import cn.tenmg.flink.jobs.launcher.config.model.Params;
import cn.tenmg.flink.jobs.launcher.utils.Sets;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class CommandLineFlinkJobsLauncher
implements FlinkJobsLauncher {
    private static final List<String> COMMAND_BEGIN = System.getProperty("os.name", "").toLowerCase().contains("windows") ? Arrays.asList("cmd", "/C") : Arrays.asList("/bin/sh", "-c");
    private static final String APPLICATION_ID_PREFFIX = "Submitting application master";
    private static final String CURRENT_STATE_PREFFIX = "Deploying cluster, current state";
    private static final String RUNNING_LOG = "YARN application has been deployed successfully.";
    private static final String FINISHED_LOG = "YARN application has been finished successfully.";
    private static int APPLICATION_ID_PREFFIX_LEN = "Submitting application master".length();
    private static int CURRENT_STATE_PREFFIX_LEN = "Deploying cluster, current state".length();
    private static Set<String> TARGETS = Sets.as("-t", "--target");
    private String flinkHome;
    private Action action = Action.RUN_APPLICATION;

    public String getFlinkHome() {
        return this.flinkHome;
    }

    public void setFlinkHome(String flinkHome) {
        this.flinkHome = flinkHome;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @Override
    public FlinkJobsLauncher.FlinkJobsApplicationInfo launch(FlinkJobs config) throws Exception {
        ArrayList<String> commandWords = new ArrayList<String>();
        commandWords.addAll(COMMAND_BEGIN);
        commandWords.add(this.flinkHome + "/bin/flink");
        commandWords.add(this.action.getName());
        this.attachOptions(commandWords, config.getOptions());
        String mainClass = config.getMainClass();
        if (mainClass != null) {
            commandWords.add("-c");
            commandWords.add(mainClass);
        }
        commandWords.add(config.getJar());
        Params params = config.getParams();
        if (params != null) {
            commandWords.add(JSON.toJSONString((Object)params));
        }
        String[] cmdarray = commandWords.toArray(new String[commandWords.size()]);
        System.out.println("Execute command: " + String.join((CharSequence)" ", commandWords));
        Process p = null;
        InputStream is = null;
        BufferedReader r = null;
        try {
            String line;
            p = Runtime.getRuntime().exec(cmdarray, null, new File(this.flinkHome));
            is = p.getInputStream();
            r = new BufferedReader(new InputStreamReader(is));
            String applicationId = null;
            FlinkJobsLauncher.FlinkJobsApplicationInfo.State state = FlinkJobsLauncher.FlinkJobsApplicationInfo.State.SUBMITTED;
            while ((line = r.readLine()) != null) {
                System.out.println(line);
                int index = line.indexOf(APPLICATION_ID_PREFFIX);
                if (index >= 0) {
                    applicationId = line.substring(index + APPLICATION_ID_PREFFIX_LEN).trim();
                    continue;
                }
                index = line.indexOf(CURRENT_STATE_PREFFIX);
                if (index >= 0) {
                    try {
                        state = FlinkJobsLauncher.FlinkJobsApplicationInfo.State.valueOf(line.substring(index + CURRENT_STATE_PREFFIX_LEN).trim());
                    }
                    catch (Exception e) {
                        state = FlinkJobsLauncher.FlinkJobsApplicationInfo.State.SUBMITTED;
                    }
                    continue;
                }
                if (line.contains(RUNNING_LOG)) {
                    state = FlinkJobsLauncher.FlinkJobsApplicationInfo.State.RUNNING;
                    continue;
                }
                if (!line.contains(FINISHED_LOG)) continue;
                state = FlinkJobsLauncher.FlinkJobsApplicationInfo.State.FINISHED;
            }
            p.waitFor();
            FlinkJobsLauncher.FlinkJobsApplicationInfo flinkJobsApplicationInfo = FlinkJobsLauncher.FlinkJobsApplicationInfoBuilder.build(applicationId, state);
            return flinkJobsApplicationInfo;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (r != null) {
                r.close();
            }
            if (p != null) {
                p.destroy();
            }
        }
    }

    protected void attachOptions(List<String> commandWords, Options options) {
        String targetKey = null;
        String target = null;
        if (options != null) {
            String preffix = options.getKeyPreffix();
            List<Option> option = options.getOption();
            if (option != null) {
                for (Option entry : option) {
                    String key = entry.getKey();
                    if (!key.startsWith("-")) {
                        key = preffix + key;
                    }
                    String value = entry.getValue();
                    if (TARGETS.contains(key)) {
                        if (value == null || value.isEmpty()) continue;
                        targetKey = key;
                        target = value;
                        continue;
                    }
                    commandWords.add(key);
                    if (value == null || value.isEmpty()) continue;
                    commandWords.add(value);
                }
            }
        }
        if (target == null) {
            if (Action.RUN_APPLICATION.equals((Object)this.action)) {
                commandWords.add("-t");
                commandWords.add("yarn-application");
            }
        } else {
            commandWords.add(targetKey);
            commandWords.add(target);
        }
    }

    public static enum Action {
        RUN("run"),
        RUN_APPLICATION("run-application");

        private String name;

        private Action(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

