package cn.tenmg.flink.jobs;

import cn.tenmg.flink.jobs.FlinkJobsLauncher.FlinkJobsApplicationInfo.State;
import cn.tenmg.flink.jobs.launcher.config.model.FlinkJobs;

/**
 * flink-jobs应用程序启动器
 * 
 * @author 赵伟均 wjzhao@aliyun.com
 *
 */
public interface FlinkJobsLauncher {

	/**
	 * 启动flink-jobs应用程序
	 * 
	 * @param config
	 *            运行配置
	 * @throws Exception
	 *             发生异常
	 */
	FlinkJobsApplicationInfo launch(FlinkJobs config) throws Exception;

	/**
	 * flink-jobs应用程序信息
	 * 
	 * @author 赵伟均 wjzhao@aliyun.com
	 *
	 */
	public static interface FlinkJobsApplicationInfo {

		/**
		 * 获取应用编号
		 * 
		 * @return 返回应用编号
		 */
		String getApplicationId();

		/**
		 * 获取应用状态
		 * 
		 * @return 返回应用状态
		 */
		State getState();

		public enum State {
			/**
			 * 已提交
			 */
			SUBMITTED,
			/**
			 * 已接受
			 */
			ACCEPTED,
			/**
			 * 正在运行
			 */
			RUNNING,
			/**
			 * 已完成
			 */
			FINISHED,
			/**
			 * 失败的
			 */
			FAILED,
			/**
			 * 被杀死
			 */
			KILLED
		}

	}

	public static class FlinkJobsApplicationInfoBuilder {

		public static FlinkJobsApplicationInfo build(String applicationId, State state) {

			return new FlinkJobsApplicationInfo() {

				@Override
				public String getApplicationId() {
					return applicationId;
				}

				@Override
				public State getState() {
					return state;
				}

			};
		}
	}

}
