/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.metadata.getter;

import cn.tenmg.dsl.utils.DSLUtils;
import cn.tenmg.dsl.utils.MapUtils;
import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.metadata.MetaDataGetter;
import cn.tenmg.flink.jobs.utils.JDBCUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractJDBCMetaDataGetter
implements MetaDataGetter {
    protected static final String COLUMN_NAME = "COLUMN_NAME";
    protected static final String DATA_TYPE = "DATA_TYPE";
    protected static final String COLUMN_SIZE = "COLUMN_SIZE";
    protected static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    protected static final String IS_NULLABLE = "IS_NULLABLE";
    protected static final String NO = "NO";
    protected static final String LEFT_BRACKET = "(";
    protected static final String RIGTH_BRACKET = ")";
    protected static final String TYPE_PREFFIX = "flink.sql.type.";
    protected static final String DEFAULT_TYPE = FlinkJobsContext.getProperty("flink.sql.type.default");
    private static final Map<Integer, String> SQL_TYPES = MapUtils.newHashMapBuilder((Object)12, (Object)"java.sql.Types.VARCHAR").put((Object)1, (Object)"java.sql.Types.CHAR").put((Object)-9, (Object)"java.sql.Types.NVARCHAR").put((Object)-15, (Object)"java.sql.Types.NCHAR").put((Object)-16, (Object)"java.sql.Types.LONGNVARCHAR").put((Object)-1, (Object)"java.sql.Types.LONGVARCHAR").put((Object)-5, (Object)"java.sql.Types.BIGINT").put((Object)16, (Object)"java.sql.Types.BOOLEAN").put((Object)-7, (Object)"java.sql.Types.BIT").put((Object)3, (Object)"java.sql.Types.DECIMAL").put((Object)1111, (Object)"java.sql.Types.OTHER").put((Object)8, (Object)"java.sql.Types.DOUBLE").put((Object)6, (Object)"java.sql.Types.FLOAT").put((Object)7, (Object)"java.sql.Types.REAL").put((Object)4, (Object)"java.sql.Types.INTEGER").put((Object)2, (Object)"java.sql.Types.NUMERIC").put((Object)5, (Object)"java.sql.Types.SMALLINT").put((Object)-6, (Object)"java.sql.Types.TINYINT").put((Object)91, (Object)"java.sql.Types.DATE").put((Object)92, (Object)"java.sql.Types.TIME").put((Object)2013, (Object)"java.sql.Types.TIME_WITH_TIMEZONE").put((Object)93, (Object)"java.sql.Types.TIMESTAMP").put((Object)2014, (Object)"java.sql.Types.TIMESTAMP_WITH_TIMEZONE").put((Object)-2, (Object)"java.sql.Types.BINARY").put((Object)-4, (Object)"java.sql.Types.LONGVARBINARY").put((Object)-3, (Object)"java.sql.Types.VARBINARY").put((Object)2006, (Object)"java.sql.Types.REF").put((Object)70, (Object)"java.sql.Types.DATALINK").put((Object)2003, (Object)"java.sql.Types.ARRAY").put((Object)2004, (Object)"java.sql.Types.BLOB").put((Object)2005, (Object)"java.sql.Types.CLOB").put((Object)2011, (Object)"java.sql.Types.NCLOB").build((Object)2002, (Object)"java.sql.Types.STRUCT");
    private static Set<String> WITH_PRECISION = AbstractJDBCMetaDataGetter.asSafeSet(FlinkJobsContext.getProperty(Arrays.asList("flink.sql.type.with_precision", "flink.sql.type.with-precision")));
    private static Set<String> WITH_SIZE = AbstractJDBCMetaDataGetter.asSafeSet(FlinkJobsContext.getProperty(Arrays.asList("flink.sql.type.with_size", "flink.sql.type.with-size")));

    protected Connection getConnection(Map<String, String> dataSource) throws Exception {
        return JDBCUtils.getConnection(dataSource);
    }

    abstract Set<String> getPrimaryKeys(Connection var1, String var2, String var3, String var4) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataGetter.TableMetaData getTableMetaData(Map<String, String> dataSource, String tableName) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection(dataSource);
            con.setAutoCommit(true);
            DatabaseMetaData metaData = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = con.getSchema();
            Set<String> primaryKeys = this.getPrimaryKeys(con, catalog, schema, tableName);
            ResultSet columnsSet = metaData.getColumns(catalog, schema, tableName, null);
            LinkedHashMap<String, String> columns = new LinkedHashMap<String, String>();
            while (columnsSet.next()) {
                String columnName = columnsSet.getString(COLUMN_NAME);
                String type = AbstractJDBCMetaDataGetter.getType(dataSource, columnsSet.getInt(DATA_TYPE), columnsSet.getInt(COLUMN_SIZE), columnsSet.getInt(DECIMAL_DIGITS));
                if (NO.equals(columnsSet.getString(IS_NULLABLE))) {
                    type = type + " NOT NULL";
                }
                columns.put(columnName, type);
            }
            MetaDataGetter.TableMetaData tableMetaData = new MetaDataGetter.TableMetaData(primaryKeys, columns);
            return tableMetaData;
        }
        finally {
            JDBCUtils.close(con);
        }
    }

    private static String getType(Map<String, String> dataSource, int dataType, int columnSize, int decimalDigits) {
        String sqlType = SQL_TYPES.get(dataType);
        String type = DEFAULT_TYPE;
        if (sqlType != null) {
            String url;
            String possibleType;
            String connector = dataSource.get("connector");
            String string = possibleType = connector == null ? null : AbstractJDBCMetaDataGetter.getSpecificProductType(connector.trim(), sqlType);
            if (StringUtils.isBlank((String)possibleType) && StringUtils.isNotBlank((String)(url = dataSource.get("url")))) {
                possibleType = AbstractJDBCMetaDataGetter.getSpecificProductType(JDBCUtils.getProduct(url), sqlType);
            }
            if (StringUtils.isBlank((String)possibleType)) {
                possibleType = FlinkJobsContext.getProperty(sqlType);
            }
            if (StringUtils.isBlank((String)possibleType)) {
                possibleType = FlinkJobsContext.getProperty(sqlType + LEFT_BRACKET + columnSize + "," + decimalDigits + RIGTH_BRACKET);
                if (StringUtils.isBlank((String)possibleType)) {
                    possibleType = FlinkJobsContext.getProperty(sqlType + LEFT_BRACKET + columnSize + RIGTH_BRACKET);
                    if (StringUtils.isNotBlank((String)possibleType)) {
                        type = possibleType;
                    }
                } else {
                    type = possibleType;
                }
            } else {
                type = possibleType;
            }
        }
        return AbstractJDBCMetaDataGetter.wrapType(type, columnSize, decimalDigits);
    }

    private static String getSpecificProductType(String product, String sqlType) {
        return FlinkJobsContext.getProperty(TYPE_PREFFIX + product + "." + sqlType);
    }

    private static String wrapType(String possibleType, int columnSize, int decimalDigits) {
        if ((possibleType = possibleType.trim()).endsWith(RIGTH_BRACKET)) {
            return DSLUtils.parse((String)possibleType, (Object)MapUtils.newHashMapBuilder((Object)"columnSize", (Object)columnSize).build((Object)"decimalDigits", (Object)decimalDigits)).getScript();
        }
        if (WITH_PRECISION.contains(possibleType)) {
            return possibleType + LEFT_BRACKET + columnSize + "," + decimalDigits + RIGTH_BRACKET;
        }
        if (WITH_SIZE.contains(possibleType)) {
            String prefix = TYPE_PREFFIX + possibleType + ".";
            String sizeOffset = FlinkJobsContext.getProperty(Arrays.asList(prefix.concat("size_offset"), prefix.concat("size-offset")));
            if (StringUtils.isBlank((String)sizeOffset)) {
                return possibleType + LEFT_BRACKET + columnSize + RIGTH_BRACKET;
            }
            int offset = Integer.parseInt(sizeOffset);
            if (columnSize >= offset) {
                return possibleType + LEFT_BRACKET + (columnSize - offset) + RIGTH_BRACKET;
            }
        }
        return possibleType;
    }

    private static final Set<String> asSafeSet(String string) {
        HashSet<String> set = new HashSet<String>();
        if (string != null) {
            String[] strings = string.split(",");
            for (int i = 0; i < strings.length; ++i) {
                set.add(strings[i].trim());
            }
        }
        return set;
    }
}

