/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.metadata;

import cn.tenmg.dsl.utils.StringUtils;
import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.exception.IllegalConfigurationException;
import cn.tenmg.flink.jobs.metadata.MetaDataGetter;
import java.util.HashMap;
import java.util.Map;

public abstract class MetaDataGetterFactory {
    private static final String METADATA_GETTER_KEY_PREFIX = "metadata.getter.";
    private static volatile Map<String, MetaDataGetter> META_DATA_GETTERS = new HashMap<String, MetaDataGetter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaDataGetter getMetaDataGetter(Map<String, String> dataSource) {
        String connector = dataSource.get("connector");
        MetaDataGetter metaDataGetter = META_DATA_GETTERS.get(connector);
        if (metaDataGetter == null) {
            Map<String, MetaDataGetter> map = META_DATA_GETTERS;
            synchronized (map) {
                metaDataGetter = META_DATA_GETTERS.get(connector);
                if (metaDataGetter == null) {
                    String key = METADATA_GETTER_KEY_PREFIX + connector;
                    String className = FlinkJobsContext.getProperty(key);
                    if (className == null) {
                        throw new IllegalArgumentException("MetaDataGetter for connector '" + connector + "' is not supported, Please consider manually implementing the interface " + MetaDataGetter.class.getName() + " and specifying the configuration key '" + key + "' to your own class name in the configuration");
                    }
                    if (StringUtils.isBlank((String)className)) {
                        throw new IllegalConfigurationException("The configuration of key '" + key + "' must be not blank");
                    }
                    try {
                        metaDataGetter = (MetaDataGetter)Class.forName(className).newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Cannot instantiate MetaDataGetter for connector '" + connector + "'", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Wrong MetaDataGetter configuration for connector " + connector + "'", e);
                    }
                    META_DATA_GETTERS.put(connector, metaDataGetter);
                }
            }
        }
        return metaDataGetter;
    }
}

