/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.configuration.loader;

import cn.tenmg.flink.jobs.configuration.loader.PropertiesFileConfigurationLoader;
import cn.tenmg.flink.jobs.exception.ConfigurationLoadException;
import cn.tenmg.flink.jobs.utils.ConfigurationUtils;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;

public class NacosConfigurationLoader
extends PropertiesFileConfigurationLoader {
    private static final String NACOS_CONFIG_PREFIX = "nacos.config.";

    @Override
    public void load(Properties config) throws ConfigurationLoadException {
        super.load(config);
        this.loadNacosConfig(config, ConfigurationUtils.getPrefixedKeyValuePairs(config, NACOS_CONFIG_PREFIX, true));
        this.replacePlaceHolder(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadNacosConfig(Properties config, Properties nacos) throws ConfigurationLoadException {
        String group = nacos.getProperty("group");
        String[] dataIds = nacos.getProperty("dataIds").split(",");
        String dataId = null;
        long timeoutMs = Long.valueOf(ConfigurationUtils.getProperty(nacos, Arrays.asList("pollTimeoutMs", "configLongPollTimeout"), "3000"));
        try {
            ConfigService configService = NacosFactory.createConfigService((Properties)nacos);
            for (int i = 0; i < dataIds.length; ++i) {
                dataId = dataIds[i];
                String content = configService.getConfig(dataId, group, timeoutMs);
                try {
                    StringReader sr = new StringReader(content);
                    try {
                        config.load(sr);
                        continue;
                    }
                    finally {
                        sr.close();
                        sr = null;
                    }
                }
                catch (IOException e) {
                    throw new ConfigurationLoadException("Unable to load configuration from content: " + content, e);
                }
            }
        }
        catch (NacosException e) {
            throw new ConfigurationLoadException("Unable to get configuration from nacos wich dataId is " + dataId, e);
        }
    }
}

