/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs;

import cn.tenmg.flink.jobs.context.FlinkJobsContext;
import cn.tenmg.flink.jobs.model.Arguments;
import cn.tenmg.flink.jobs.utils.OperatorUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

public abstract class BasicFlinkJobsRunner {
    protected abstract void run(StreamExecutionEnvironment var1, Arguments var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) throws Exception {
        Arguments arguments;
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("You must provide a parameter in JSON format or the path of json file");
        }
        if (args.length > 1) {
            throw new IllegalArgumentException("Too many parameters. You must provide a parameter in JSON format or the path of json file");
        }
        String json = args[0];
        if (json.endsWith(".json")) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(json);
                arguments = (Arguments)JSON.parseObject((InputStream)fis, Arguments.class, (Feature[])new Feature[0]);
            }
            finally {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
            }
        } else {
            arguments = (Arguments)JSON.parseObject((String)json, Arguments.class);
        }
        StreamExecutionEnvironment env = FlinkJobsContext.getExecutionEnvironment(arguments.getConfiguration());
        RuntimeExecutionMode mode = arguments.getRuntimeMode();
        if (RuntimeExecutionMode.BATCH.equals((Object)mode)) {
            env.setRuntimeMode(RuntimeExecutionMode.BATCH);
        } else if (RuntimeExecutionMode.STREAMING.equals((Object)mode)) {
            env.setRuntimeMode(RuntimeExecutionMode.STREAMING);
        } else if (RuntimeExecutionMode.AUTOMATIC.equals((Object)mode)) {
            env.setRuntimeMode(RuntimeExecutionMode.AUTOMATIC);
        }
        Map<String, Object> params = arguments.getParams();
        if (params == null) {
            params = new HashMap<String, Object>();
            arguments.setParams(params);
        }
        this.operates(env, arguments.getOperates(), params);
        this.run(env, arguments);
        FlinkJobsContext.remove();
    }

    private void operates(StreamExecutionEnvironment env, List<String> operates, Map<String, Object> params) throws Exception {
        if (operates != null) {
            for (int i = 0; i < operates.size(); ++i) {
                String operate = operates.get(i);
                OperatorUtils.getOperator(JSON.parseObject((String)operate).getString("type")).execute(env, operate, params);
            }
        }
    }
}

