/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.config.loader;

import cn.tenmg.flink.jobs.config.ConfigLoader;
import cn.tenmg.flink.jobs.config.model.FlinkJobs;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class XMLConfigLoader
implements ConfigLoader {
    private static final XMLConfigLoader INSTANCE = new XMLConfigLoader();
    private static Unmarshaller unmarshaller;

    private XMLConfigLoader() {
    }

    public static final XMLConfigLoader getInstance() {
        return INSTANCE;
    }

    @Override
    public FlinkJobs load(String s) {
        try {
            return (FlinkJobs)unmarshaller.unmarshal((Reader)new StringReader(s));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Failed to load the flink-jobs configuration", e);
        }
    }

    @Override
    public FlinkJobs load(File file) {
        try {
            return (FlinkJobs)unmarshaller.unmarshal(file);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Failed to load the flink-jobs configuration", e);
        }
    }

    @Override
    public FlinkJobs load(FileReader fr) {
        try {
            return (FlinkJobs)unmarshaller.unmarshal((Reader)fr);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Failed to load the flink-jobs configuration", e);
        }
    }

    @Override
    public FlinkJobs load(InputStream is) {
        try {
            return (FlinkJobs)unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Failed to load the flink-jobs configuration", e);
        }
    }

    static {
        try {
            unmarshaller = JAXBContext.newInstance((Class[])new Class[]{FlinkJobs.class}).createUnmarshaller();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

