/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.clients;

import cn.tenmg.flink.jobs.clients.AbstractFlinkJobsClient;
import cn.tenmg.flink.jobs.clients.utils.FlinkJobsClientsUtils;
import cn.tenmg.flink.jobs.clients.utils.Sets;
import cn.tenmg.flink.jobs.config.model.FlinkJobs;
import cn.tenmg.flink.jobs.config.model.Operate;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneRestClusterClient
extends AbstractFlinkJobsClient<RestClusterClient<StandaloneClusterId>> {
    private static final char SINGLE_QUOTATION_MARK = '\'';
    private static final char BACKSLASH = '\\';
    private static final char BLANK_SPACE = ' ';
    private static final char VALUE_BEGIN = '=';
    private static final Set<Character> VALUE_END = new HashSet<Character>(){
        private static final long serialVersionUID = 6149301286530143148L;
        {
            this.add(Character.valueOf(','));
            this.add(Character.valueOf('\r'));
            this.add(Character.valueOf('\n'));
        }
    };
    private static Logger log = LoggerFactory.getLogger(StandaloneRestClusterClient.class);
    private static final Set<String> localOperates = Sets.as("Bsh", "Jdbc");
    private static final Actuator<JobID, JobGraph> submitJobActuator = new Actuator<JobID, JobGraph>(){

        @Override
        public JobID execute(RestClusterClient<StandaloneClusterId> client, JobGraph jobGraph) throws Exception {
            return (JobID)client.submitJob(jobGraph).get();
        }
    };
    private static final Actuator<Acknowledge, JobID> cancelJobActuator = new Actuator<Acknowledge, JobID>(){

        @Override
        public Acknowledge execute(RestClusterClient<StandaloneClusterId> client, JobID jobId) throws Exception {
            return (Acknowledge)client.cancel(jobId).get();
        }
    };
    private static final Actuator<Collection<JobStatusMessage>, Void> listJobsActuator = new Actuator<Collection<JobStatusMessage>, Void>(){

        @Override
        public Collection<JobStatusMessage> execute(RestClusterClient<StandaloneClusterId> client, Void none) throws Exception {
            return (Collection)client.listJobs().get();
        }
    };
    private static final Actuator<JobDetailsInfo, JobID> getJobDetailsActuator = new Actuator<JobDetailsInfo, JobID>(){

        @Override
        public JobDetailsInfo execute(RestClusterClient<StandaloneClusterId> client, JobID jobId) throws Exception {
            return (JobDetailsInfo)client.getJobDetails(jobId).get();
        }
    };
    private static final Actuator<JobStatus, JobID> getJobStatusActuator = new Actuator<JobStatus, JobID>(){

        @Override
        public JobStatus execute(RestClusterClient<StandaloneClusterId> client, JobID jobId) throws Exception {
            return (JobStatus)client.getJobStatus(jobId).get();
        }
    };
    private static final Actuator<JobResult, JobID> requestJobResultActuator = new Actuator<JobResult, JobID>(){

        @Override
        public JobResult execute(RestClusterClient<StandaloneClusterId> client, JobID jobId) throws Exception {
            return (JobResult)client.requestJobResult(jobId).get();
        }
    };
    private static final Actuator<String, JobStopParams> stopJobActuator = new Actuator<String, JobStopParams>(){

        @Override
        public String execute(RestClusterClient<StandaloneClusterId> client, JobStopParams jobStopParams) throws Exception {
            return FlinkJobsClientsUtils.stop(client, jobStopParams.jobId, jobStopParams.savepointsDir).get();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobID submit(FlinkJobs flinkJobs) throws Exception {
        List operates;
        HashMap options = flinkJobs.getOptions();
        String classpaths = this.properties.getProperty("classpaths");
        String parallelism = this.properties.getProperty("parallelism.default", "1");
        SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
        if (options != null && !options.isEmpty()) {
            if (options.containsKey("classpaths")) {
                classpaths = (String)options.get("classpaths");
            }
            if (options.containsKey("parallelism")) {
                parallelism = (String)options.get("parallelism");
            }
            if (!flinkJobs.isAllwaysNewJob() && options.containsKey("fromSavepoint")) {
                String savepointPath = (String)options.get("fromSavepoint");
                savepointRestoreSettings = options.containsKey("allowNonRestoredState") ? SavepointRestoreSettings.forPath((String)savepointPath, (boolean)"true".equals(options.get("allowNonRestoredState"))) : SavepointRestoreSettings.forPath((String)savepointPath);
            }
        }
        Properties customConf = StandaloneRestClusterClient.load(flinkJobs.getConfiguration());
        Configuration configuration = this.getConfiguration(customConf);
        PackagedProgram.Builder builder = PackagedProgram.newBuilder().setConfiguration(configuration).setEntryPointClassName(this.getEntryPointClassName(flinkJobs)).setJarFile(this.getJar(flinkJobs)).setUserClassPaths(StandaloneRestClusterClient.toURLs(classpaths)).setSavepointRestoreSettings(savepointRestoreSettings);
        String arguments = StandaloneRestClusterClient.getArguments(flinkJobs);
        if (!StandaloneRestClusterClient.isEmptyArguments(arguments).booleanValue()) {
            builder.setArguments(new String[]{arguments});
        }
        boolean submit = true;
        if (StandaloneRestClusterClient.isBlank(flinkJobs.getServiceName()) && (operates = flinkJobs.getOperates()) != null && !operates.isEmpty()) {
            submit = false;
            int size = operates.size();
            for (int i = 0; i < size; ++i) {
                if (localOperates.contains(((Operate)operates.get(i)).getType())) continue;
                submit = true;
                break;
            }
        }
        PackagedProgram packagedProgram = null;
        try {
            packagedProgram = builder.build();
            if (submit) {
                JobGraph jobGraph = PackagedProgramUtils.createJobGraph((PackagedProgram)packagedProgram, (Configuration)configuration, (int)Integer.parseInt(parallelism), (boolean)Boolean.valueOf(this.properties.getProperty("suppress.output", "false")));
                JobID jobID = this.retry(submitJobActuator, jobGraph, configuration, customConf);
                return jobID;
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(packagedProgram.getUserCodeClassLoader());
            try {
                packagedProgram.invokeInteractiveModeForExecution();
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        finally {
            if (packagedProgram != null) {
                packagedProgram.close();
                packagedProgram = null;
            }
        }
        return null;
    }

    @Override
    public Acknowledge cancel(JobID jobId) throws Exception {
        return this.retry(cancelJobActuator, jobId, this.getConfiguration(), null);
    }

    @Override
    public Collection<JobStatusMessage> listJobs() throws Exception {
        return this.retry(listJobsActuator, null, this.getConfiguration(), null);
    }

    public JobDetailsInfo getJobDetails(JobID jobId) throws Exception {
        return this.retry(getJobDetailsActuator, jobId, this.getConfiguration(), null);
    }

    @Override
    public JobStatus getJobStatus(JobID jobId) throws Exception {
        return this.retry(getJobStatusActuator, jobId, this.getConfiguration(), null);
    }

    @Override
    public JobResult requestJobResult(JobID jobId) throws Exception {
        return this.retry(requestJobResultActuator, jobId, this.getConfiguration(), null);
    }

    @Override
    public String stop(JobID jobId) throws Exception {
        return this.retry(stopJobActuator, new JobStopParams(jobId, this.properties.getProperty("state.savepoints.dir")), this.getConfiguration(), null);
    }

    @Override
    public RestClusterClient<StandaloneClusterId> getClusterClient() throws Exception {
        return this.newRestClusterClient(this.getConfiguration());
    }

    @Override
    public RestClusterClient<StandaloneClusterId> getClusterClient(Properties customConf) throws Exception {
        return this.newRestClusterClient(this.getConfiguration(customConf));
    }

    private <R, T> R retry(Actuator<R, T> actuator, T params, Configuration configuration, Properties customConf) throws Exception {
        int size = this.configurations.size();
        for (int i = 1; i < size; ++i) {
            try {
                return this.tryOnce(actuator, params, configuration);
            }
            catch (Exception e) {
                log.warn("The " + i + "th attempt failed, trying the " + (i + 1) + "th times");
                configuration = this.getConfiguration(customConf);
                continue;
            }
        }
        return this.tryOnce(actuator, params, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, T> R tryOnce(Actuator<R, T> actuator, T params, Configuration configuration) throws Exception {
        RestClusterClient<StandaloneClusterId> client = null;
        try {
            client = this.newRestClusterClient(configuration);
            R r = actuator.execute(client, params);
            return r;
        }
        finally {
            if (client != null) {
                client.close();
                client = null;
            }
        }
    }

    private synchronized Configuration getConfiguration() {
        Configuration configuration = (Configuration)this.configurations.poll();
        this.configurations.add(configuration);
        return configuration;
    }

    private Configuration getConfiguration(Properties customConf) {
        Configuration configuration = this.getConfiguration();
        if (customConf != null) {
            configuration = configuration.clone();
            configuration.addAll(ConfigurationUtils.createConfiguration((Properties)customConf));
        }
        return configuration;
    }

    private RestClusterClient<StandaloneClusterId> newRestClusterClient(Configuration configuration) throws Exception {
        return new RestClusterClient(configuration, (Object)StandaloneClusterId.getInstance());
    }

    private static List<URL> toURLs(String classpaths) throws MalformedURLException {
        if (StandaloneRestClusterClient.isBlank(classpaths)) {
            return Collections.emptyList();
        }
        String[] paths = classpaths.contains(";") ? classpaths.split(";") : classpaths.split(",");
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < paths.length; ++i) {
            urls.add(new URL(paths[i].trim()));
        }
        return urls;
    }

    public static Properties load(String config) {
        if (config == null) {
            return null;
        }
        Properties properties = new Properties();
        config = config.trim();
        int len = config.length();
        int i = 0;
        int backslashes = 0;
        char a = ' ';
        char b = ' ';
        boolean isString = false;
        boolean isKey = true;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        while (i < len) {
            char c = config.charAt(i);
            if (isString) {
                if (c == '\\') {
                    ++backslashes;
                } else {
                    if (StandaloneRestClusterClient.isStringEnd(a, b, c, backslashes)) {
                        isString = false;
                    }
                    backslashes = 0;
                }
                if (isKey) {
                    key.append(c);
                } else {
                    value.append(c);
                }
            } else if (c == '\'') {
                isString = true;
                if (isKey) {
                    key.append(c);
                } else {
                    value.append(c);
                }
            } else if (isKey) {
                if (c == '=') {
                    isKey = false;
                } else {
                    key.append(c);
                }
            } else {
                if (VALUE_END.contains(Character.valueOf(c))) {
                    isKey = true;
                    StandaloneRestClusterClient.put(properties, key, value);
                    key.setLength(0);
                    value.setLength(0);
                    a = b;
                    b = c;
                    ++i;
                    while (i < len && (c = config.charAt(i)) <= ' ') {
                        a = b;
                        b = c;
                        ++i;
                    }
                    continue;
                }
                value.append(c);
            }
            a = b;
            b = c;
            ++i;
        }
        if (key.length() > 0) {
            StandaloneRestClusterClient.put(properties, key, value);
        }
        return properties;
    }

    public static boolean isStringEnd(char a, char b, char c, int backslashes) {
        if (c == '\'') {
            if (b == '\\') {
                return backslashes % 2 == 0;
            }
            return true;
        }
        return false;
    }

    private static void put(Properties properties, StringBuilder key, StringBuilder value) {
        String k = key.toString().trim();
        String v = value.toString().trim();
        int last = k.length() - 1;
        if (k.charAt(0) == '\'' && k.charAt(last) == '\'') {
            k = k.substring(1, last);
        }
        properties.put(k, v);
    }

    private static interface Actuator<R, T> {
        public R execute(RestClusterClient<StandaloneClusterId> var1, T var2) throws Exception;
    }

    private static class JobStopParams {
        private JobID jobId;
        private String savepointsDir;

        public JobStopParams(JobID jobId, String savepointsDir) {
            this.jobId = jobId;
            this.savepointsDir = savepointsDir;
        }
    }
}

