/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.clients;

import cn.tenmg.flink.jobs.FlinkJobsClient;
import cn.tenmg.flink.jobs.clients.utils.PropertiesLoaderUtils;
import cn.tenmg.flink.jobs.clients.utils.Sets;
import cn.tenmg.flink.jobs.config.model.FlinkJobs;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlinkJobsClient<T extends ClusterClient<?>>
implements FlinkJobsClient<T> {
    protected static final String FLINK_JOBS_DEFAULT_JAR_KEY = "flink.jobs.default.jar";
    protected static final String FLINK_JOBS_DEFAULT_CLASS_KEY = "flink.jobs.default.class";
    protected static final Set<String> EXCLUDES = Sets.as("options", "mainClass", "jar", "allwaysNewJob");
    protected static final String EMPTY_ARGUMENTS = "{}";
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected Properties properties;
    protected final Queue<Configuration> configurations = new LinkedList<Configuration>();

    public AbstractFlinkJobsClient() {
        this.init("flink-jobs-clients.properties");
    }

    public AbstractFlinkJobsClient(String pathInClassPath) {
        this.init(pathInClassPath);
    }

    public AbstractFlinkJobsClient(Properties properties) {
        this.init(properties);
    }

    protected void init(String pathInClassPath) {
        try {
            this.properties = PropertiesLoaderUtils.loadFromClassPath(pathInClassPath);
        }
        catch (Exception e) {
            this.properties = new Properties();
            this.log.error("Failed to load configuration file " + pathInClassPath);
        }
        this.init(this.properties);
    }

    protected void init(Properties properties) {
        this.properties = properties;
        Configuration configuration = ConfigurationUtils.createConfiguration((Properties)properties);
        String rpcServers = properties.getProperty("jobmanager.rpc.servers");
        String address = properties.getProperty("rest.addresses", properties.getProperty("rest.address"));
        if (!AbstractFlinkJobsClient.isBlank(address)) {
            String[] addresses = address.split(",");
            for (int i = 0; i < addresses.length; ++i) {
                Configuration config = configuration.clone();
                String[] addr = addresses[i].split(":", 2);
                config.set(RestOptions.ADDRESS, (Object)addr[0].trim());
                if (addr.length > 1) {
                    config.set(RestOptions.PORT, (Object)Integer.parseInt(addr[1].trim()));
                } else if (!config.contains(RestOptions.PORT)) {
                    config.set(RestOptions.PORT, (Object)8081);
                }
                this.configurations.add(config);
            }
        } else if (AbstractFlinkJobsClient.isBlank(rpcServers)) {
            this.configurations.add(configuration);
        } else {
            String[] servers = rpcServers.split(",");
            for (int i = 0; i < servers.length; ++i) {
                Configuration config = configuration.clone();
                String[] server = servers[i].split(":", 2);
                config.set(JobManagerOptions.ADDRESS, (Object)server[0].trim());
                if (server.length > 1) {
                    config.set(JobManagerOptions.PORT, (Object)Integer.parseInt(server[1].trim()));
                } else if (!config.contains(JobManagerOptions.PORT)) {
                    config.set(JobManagerOptions.PORT, (Object)6123);
                }
                this.configurations.add(config);
            }
        }
    }

    protected File getJar(FlinkJobs flinkJobs) {
        String jar = this.getJarPath(flinkJobs);
        if (AbstractFlinkJobsClient.isBlank(jar)) {
            return null;
        }
        return new File(jar);
    }

    protected String getEntryPointClassName(FlinkJobs flinkJobs) {
        String mainClass = flinkJobs.getMainClass();
        if (AbstractFlinkJobsClient.isBlank(mainClass) && AbstractFlinkJobsClient.isBlank(this.getJarPath(flinkJobs))) {
            mainClass = this.properties.getProperty(FLINK_JOBS_DEFAULT_CLASS_KEY, "cn.tenmg.flink.jobs.FlinkJobsPortal");
        }
        return mainClass;
    }

    protected static String getArguments(FlinkJobs flinkJobs) {
        return JSON.toJSONString((Object)flinkJobs, (SerializeFilter)new PropertyFilter(){

            public boolean apply(Object object, String name, Object value) {
                return !EXCLUDES.contains(name);
            }
        }, (SerializerFeature[])new SerializerFeature[0]);
    }

    protected static Boolean isEmptyArguments(String arguments) {
        return AbstractFlinkJobsClient.isBlank(arguments) || EMPTY_ARGUMENTS.equals(arguments);
    }

    protected String getJarPath(FlinkJobs flinkJobs) {
        String jar = flinkJobs.getJar();
        if (AbstractFlinkJobsClient.isBlank(jar)) {
            jar = this.properties.getProperty(FLINK_JOBS_DEFAULT_JAR_KEY);
        }
        return jar;
    }

    protected static boolean isBlank(String string) {
        int len;
        if (string == null || (len = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

