/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.clients;

import cn.tenmg.flink.jobs.clients.AbstractFlinkJobsClient;
import cn.tenmg.flink.jobs.clients.utils.FlinkJobsClientsUtils;
import cn.tenmg.flink.jobs.clients.utils.Sets;
import cn.tenmg.flink.jobs.config.model.FlinkJobs;
import cn.tenmg.flink.jobs.config.model.Operate;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneRestClusterClient
extends AbstractFlinkJobsClient<RestClusterClient<StandaloneClusterId>> {
    private static Logger log = LoggerFactory.getLogger(StandaloneRestClusterClient.class);
    private static final Set<String> localOperates = Sets.as("Bsh", "Jdbc");
    private static final Actuator<JobID, JobGraph> submitJobActuator = new Actuator<JobID, JobGraph>(){

        @Override
        public JobID execute(RestClusterClient<StandaloneClusterId> client, JobGraph jobGraph) throws Exception {
            return (JobID)client.submitJob(jobGraph).get();
        }
    };
    private static final Actuator<Acknowledge, JobID> cancelJobActuator = new Actuator<Acknowledge, JobID>(){

        @Override
        public Acknowledge execute(RestClusterClient<StandaloneClusterId> client, JobID jobId) throws Exception {
            return (Acknowledge)client.cancel(jobId).get();
        }
    };
    private static final Actuator<Collection<JobStatusMessage>, Void> listJobsActuator = new Actuator<Collection<JobStatusMessage>, Void>(){

        @Override
        public Collection<JobStatusMessage> execute(RestClusterClient<StandaloneClusterId> client, Void none) throws Exception {
            return (Collection)client.listJobs().get();
        }
    };
    private static final Actuator<JobDetailsInfo, JobID> getJobDetailsActuator = new Actuator<JobDetailsInfo, JobID>(){

        @Override
        public JobDetailsInfo execute(RestClusterClient<StandaloneClusterId> client, JobID jobId) throws Exception {
            return (JobDetailsInfo)client.getJobDetails(jobId).get();
        }
    };
    private static final Actuator<JobStatus, JobID> getJobStatusActuator = new Actuator<JobStatus, JobID>(){

        @Override
        public JobStatus execute(RestClusterClient<StandaloneClusterId> client, JobID jobId) throws Exception {
            return (JobStatus)client.getJobStatus(jobId).get();
        }
    };
    private static final Actuator<JobResult, JobID> requestJobResultActuator = new Actuator<JobResult, JobID>(){

        @Override
        public JobResult execute(RestClusterClient<StandaloneClusterId> client, JobID jobId) throws Exception {
            return (JobResult)client.requestJobResult(jobId).get();
        }
    };
    private static final Actuator<String, JobStopParams> stopJobActuator = new Actuator<String, JobStopParams>(){

        @Override
        public String execute(RestClusterClient<StandaloneClusterId> client, JobStopParams jobStopParams) throws Exception {
            return FlinkJobsClientsUtils.stop(client, jobStopParams.jobId, jobStopParams.savepointsDir).get();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobID submit(FlinkJobs flinkJobs) throws Exception {
        List operates;
        HashMap options = flinkJobs.getOptions();
        String classpaths = this.properties.getProperty("classpaths");
        String parallelism = this.properties.getProperty("parallelism.default", "1");
        SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
        if (options != null && !options.isEmpty()) {
            if (options.containsKey("classpaths")) {
                classpaths = (String)options.get("classpaths");
            }
            if (options.containsKey("parallelism")) {
                parallelism = (String)options.get("parallelism");
            }
            if (!flinkJobs.isAllwaysNewJob() && options.containsKey("fromSavepoint")) {
                String savepointPath = (String)options.get("fromSavepoint");
                savepointRestoreSettings = options.containsKey("allowNonRestoredState") ? SavepointRestoreSettings.forPath((String)savepointPath, (boolean)"true".equals(options.get("allowNonRestoredState"))) : SavepointRestoreSettings.forPath((String)savepointPath);
            }
        }
        Configuration configuration = this.getConfiguration();
        PackagedProgram.Builder builder = PackagedProgram.newBuilder().setConfiguration(configuration).setEntryPointClassName(this.getEntryPointClassName(flinkJobs)).setJarFile(this.getJar(flinkJobs)).setUserClassPaths(StandaloneRestClusterClient.toURLs(classpaths)).setSavepointRestoreSettings(savepointRestoreSettings);
        String arguments = StandaloneRestClusterClient.getArguments(flinkJobs);
        if (!StandaloneRestClusterClient.isEmptyArguments(arguments).booleanValue()) {
            builder.setArguments(new String[]{arguments});
        }
        boolean submit = true;
        if (flinkJobs.getServiceName() == null && (operates = flinkJobs.getOperates()) != null && !operates.isEmpty()) {
            submit = false;
            int size = operates.size();
            for (int i = 0; i < size; ++i) {
                if (localOperates.contains(((Operate)operates.get(i)).getType())) continue;
                submit = true;
                break;
            }
        }
        PackagedProgram packagedProgram = null;
        try {
            packagedProgram = builder.build();
            if (submit) {
                JobGraph jobGraph = PackagedProgramUtils.createJobGraph((PackagedProgram)packagedProgram, (Configuration)configuration, (int)Integer.parseInt(parallelism), (boolean)Boolean.valueOf(this.properties.getProperty("suppress.output", "false")));
                Properties customConf = StandaloneRestClusterClient.toProperties(flinkJobs.getConfiguration());
                JobID jobID = this.retry(submitJobActuator, jobGraph, configuration, customConf);
                return jobID;
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(packagedProgram.getUserCodeClassLoader());
            try {
                packagedProgram.invokeInteractiveModeForExecution();
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        finally {
            if (packagedProgram != null) {
                packagedProgram.close();
                packagedProgram = null;
            }
        }
        return null;
    }

    @Override
    public Acknowledge cancel(JobID jobId) throws Exception {
        return this.retry(cancelJobActuator, jobId, this.getConfiguration(), null);
    }

    @Override
    public Collection<JobStatusMessage> listJobs() throws Exception {
        return this.retry(listJobsActuator, null, this.getConfiguration(), null);
    }

    public JobDetailsInfo getJobDetails(JobID jobId) throws Exception {
        return this.retry(getJobDetailsActuator, jobId, this.getConfiguration(), null);
    }

    @Override
    public JobStatus getJobStatus(JobID jobId) throws Exception {
        return this.retry(getJobStatusActuator, jobId, this.getConfiguration(), null);
    }

    @Override
    public JobResult requestJobResult(JobID jobId) throws Exception {
        return this.retry(requestJobResultActuator, jobId, this.getConfiguration(), null);
    }

    @Override
    public String stop(JobID jobId) throws Exception {
        return this.retry(stopJobActuator, new JobStopParams(jobId, this.properties.getProperty("state.savepoints.dir")), this.getConfiguration(), null);
    }

    @Override
    public RestClusterClient<StandaloneClusterId> getClusterClient() throws Exception {
        return this.newRestClusterClient(this.getConfiguration());
    }

    @Override
    public RestClusterClient<StandaloneClusterId> getClusterClient(Properties customConf) throws Exception {
        return this.getRestClusterClient(this.getConfiguration(), customConf);
    }

    private <R, T> R retry(Actuator<R, T> actuator, T params, Configuration configuration, Properties customConf) throws Exception {
        int size = this.configurations.size();
        for (int i = 1; i < size; ++i) {
            try {
                return this.tryOnce(actuator, params, configuration, customConf);
            }
            catch (Exception e) {
                log.warn("The " + i + "th attempt failed, trying the " + (i + 1) + "th times");
                continue;
            }
        }
        return this.tryOnce(actuator, params, configuration, customConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, T> R tryOnce(Actuator<R, T> actuator, T params, Configuration configuration, Properties customConf) throws Exception {
        RestClusterClient<StandaloneClusterId> client = null;
        try {
            client = this.getRestClusterClient(configuration, customConf);
            R r = actuator.execute(client, params);
            return r;
        }
        finally {
            if (client != null) {
                client.close();
                client = null;
            }
        }
    }

    private synchronized Configuration getConfiguration() {
        Configuration configuration = (Configuration)this.configurations.poll();
        this.configurations.add(configuration);
        return configuration;
    }

    private RestClusterClient<StandaloneClusterId> getRestClusterClient(Configuration configuration, Properties customConf) throws Exception {
        if (customConf != null) {
            configuration = configuration.clone();
            configuration.addAll(ConfigurationUtils.createConfiguration((Properties)customConf));
        }
        return this.newRestClusterClient(configuration);
    }

    private RestClusterClient<StandaloneClusterId> newRestClusterClient(Configuration configuration) throws Exception {
        return new RestClusterClient(configuration, (Object)StandaloneClusterId.getInstance());
    }

    private static List<URL> toURLs(String classpaths) throws MalformedURLException {
        if (classpaths == null || "".equals(classpaths.trim())) {
            return Collections.emptyList();
        }
        String[] paths = classpaths.contains(";") ? classpaths.split(";") : classpaths.split(",");
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < paths.length; ++i) {
            urls.add(new URL(paths[i].trim()));
        }
        return urls;
    }

    private static Properties toProperties(String configuration) throws IOException {
        Properties properties = null;
        if (configuration != null) {
            properties = new Properties();
            properties.load(new StringReader(configuration));
        }
        return properties;
    }

    private static interface Actuator<R, T> {
        public R execute(RestClusterClient<StandaloneClusterId> var1, T var2) throws Exception;
    }

    private static class JobStopParams {
        private JobID jobId;
        private String savepointsDir;

        public JobStopParams(JobID jobId, String savepointsDir) {
            this.jobId = jobId;
            this.savepointsDir = savepointsDir;
        }
    }
}

