/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.clients;

import cn.tenmg.flink.jobs.clients.AbstractFlinkJobsClient;
import cn.tenmg.flink.jobs.clients.context.FlinkJobsClientsContext;
import cn.tenmg.flink.jobs.clients.utils.FlinkJobsClientsUtils;
import cn.tenmg.flink.jobs.clients.utils.Sets;
import cn.tenmg.flink.jobs.config.model.FlinkJobs;
import cn.tenmg.flink.jobs.config.model.Operate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;

public class StandaloneRestClusterClient
extends AbstractFlinkJobsClient<StandaloneClusterId> {
    private static final Queue<Configuration> configurations = new LinkedList<Configuration>();
    private static final int COUNT;
    private static final Set<String> localOperates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobID submit(FlinkJobs flinkJobs) throws Exception {
        HashMap options = flinkJobs.getOptions();
        String classpaths = FlinkJobsClientsContext.getProperty("classpaths");
        String parallelism = FlinkJobsClientsContext.getProperty("parallelism.default", "1");
        SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
        if (options != null && !options.isEmpty()) {
            if (options.containsKey("classpaths")) {
                classpaths = (String)options.get("classpaths");
            }
            if (options.containsKey("parallelism")) {
                parallelism = (String)options.get("parallelism");
            }
            if (!flinkJobs.isAllwaysNewJob() && options.containsKey("fromSavepoint")) {
                String savepointPath = (String)options.get("fromSavepoint");
                savepointRestoreSettings = options.containsKey("allowNonRestoredState") ? SavepointRestoreSettings.forPath((String)savepointPath, (boolean)"true".equals(options.get("allowNonRestoredState"))) : SavepointRestoreSettings.forPath((String)savepointPath);
            }
        }
        Configuration configuration = StandaloneRestClusterClient.getConfiguration();
        PackagedProgram.Builder builder = PackagedProgram.newBuilder().setConfiguration(configuration).setEntryPointClassName(StandaloneRestClusterClient.getEntryPointClassName(flinkJobs)).setJarFile(new File(StandaloneRestClusterClient.getJar(flinkJobs))).setUserClassPaths(StandaloneRestClusterClient.toURLs(classpaths)).setSavepointRestoreSettings(savepointRestoreSettings);
        String arguments = StandaloneRestClusterClient.getArguments(flinkJobs);
        if (!StandaloneRestClusterClient.isEmptyArguments(arguments).booleanValue()) {
            builder.setArguments(new String[]{arguments});
        }
        boolean submit = true;
        if (flinkJobs.getServiceName() == null) {
            submit = false;
            List operates = flinkJobs.getOperates();
            if (operates != null) {
                int size = operates.size();
                for (int i = 0; i < size; ++i) {
                    if (localOperates.contains(((Operate)operates.get(i)).getType())) continue;
                    submit = true;
                    break;
                }
            }
        }
        PackagedProgram packagedProgram = builder.build();
        boolean suppressOutput = Boolean.valueOf(FlinkJobsClientsContext.getProperty("suppress.output", "false"));
        if (submit) {
            final JobGraph jobGraph = PackagedProgramUtils.createJobGraph((PackagedProgram)packagedProgram, (Configuration)configuration, (int)Integer.parseInt(parallelism), (boolean)suppressOutput);
            Properties customConf = StandaloneRestClusterClient.toProperties(flinkJobs.getConfiguration());
            return this.retry(new Actuator<JobID>(){

                @Override
                public JobID execute(RestClusterClient<StandaloneClusterId> client) throws Exception {
                    return (JobID)client.submitJob(jobGraph).get();
                }
            }, configuration, customConf);
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(packagedProgram.getUserCodeClassLoader());
        PrintStream originalOut = System.out;
        PrintStream originalErr = System.err;
        if (suppressOutput) {
            ByteArrayOutputStream stdOutBuffer = new ByteArrayOutputStream();
            System.setOut(new PrintStream(stdOutBuffer));
            ByteArrayOutputStream stdErrBuffer = new ByteArrayOutputStream();
            System.setErr(new PrintStream(stdErrBuffer));
        } else {
            Object stdOutBuffer = null;
            Object stdErrBuffer = null;
        }
        try {
            packagedProgram.invokeInteractiveModeForExecution();
        }
        finally {
            if (suppressOutput) {
                System.setOut(originalOut);
                System.setErr(originalErr);
            }
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return null;
    }

    @Override
    public Acknowledge cancel(final JobID jobId) throws Exception {
        return this.retry(new Actuator<Acknowledge>(){

            @Override
            public Acknowledge execute(RestClusterClient<StandaloneClusterId> client) throws Exception {
                return (Acknowledge)client.cancel(jobId).get();
            }
        }, StandaloneRestClusterClient.getConfiguration(), null);
    }

    @Override
    public Collection<JobStatusMessage> listJobs() throws Exception {
        return this.retry(new Actuator<Collection<JobStatusMessage>>(){

            @Override
            public Collection<JobStatusMessage> execute(RestClusterClient<StandaloneClusterId> client) throws Exception {
                return (Collection)client.listJobs().get();
            }
        }, StandaloneRestClusterClient.getConfiguration(), null);
    }

    public JobDetailsInfo getJobDetails(final JobID jobId) throws Exception {
        return this.retry(new Actuator<JobDetailsInfo>(){

            @Override
            public JobDetailsInfo execute(RestClusterClient<StandaloneClusterId> client) throws Exception {
                return (JobDetailsInfo)client.getJobDetails(jobId).get();
            }
        }, StandaloneRestClusterClient.getConfiguration(), null);
    }

    @Override
    public JobStatus getJobStatus(final JobID jobId) throws Exception {
        return this.retry(new Actuator<JobStatus>(){

            @Override
            public JobStatus execute(RestClusterClient<StandaloneClusterId> client) throws Exception {
                return (JobStatus)client.getJobStatus(jobId).get();
            }
        }, StandaloneRestClusterClient.getConfiguration(), null);
    }

    @Override
    public JobResult requestJobResult(final JobID jobId) throws Exception {
        return this.retry(new Actuator<JobResult>(){

            @Override
            public JobResult execute(RestClusterClient<StandaloneClusterId> client) throws Exception {
                return (JobResult)client.requestJobResult(jobId).get();
            }
        }, StandaloneRestClusterClient.getConfiguration(), null);
    }

    @Override
    public String stop(final JobID jobId) throws Exception {
        return this.retry(new Actuator<String>(){

            @Override
            public String execute(RestClusterClient<StandaloneClusterId> client) throws Exception {
                return FlinkJobsClientsUtils.stop(client, jobId).get();
            }
        }, StandaloneRestClusterClient.getConfiguration(), null);
    }

    @Override
    public RestClusterClient<StandaloneClusterId> getClusterClient() throws Exception {
        return this.newRestClusterClient(StandaloneRestClusterClient.getConfiguration());
    }

    @Override
    public RestClusterClient<StandaloneClusterId> getClusterClient(Properties customConf) throws Exception {
        return this.getRestClusterClient(StandaloneRestClusterClient.getConfiguration(), customConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T retry(Actuator<T> actuator, Configuration configuration, Properties customConf) throws Exception {
        try (RestClusterClient<StandaloneClusterId> client = null;){
            client = this.getRestClusterClient(configuration, customConf);
            for (int i = 0; i < COUNT; ++i) {
                T t;
                try {
                    t = actuator.execute(client);
                }
                catch (Exception e) {
                    try {
                        if (client != null) {
                            client.close();
                        }
                        if (i >= COUNT) {
                            throw e;
                        }
                        client = this.getRestClusterClient(StandaloneRestClusterClient.getConfiguration(), customConf);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
                return t;
            }
        }
    }

    private static synchronized Configuration getConfiguration() {
        Configuration configuration = configurations.poll();
        configurations.add(configuration);
        return configuration;
    }

    private RestClusterClient<StandaloneClusterId> getRestClusterClient(Configuration configuration, Properties customConf) throws Exception {
        if (customConf != null) {
            configuration = configuration.clone();
            configuration.addAll(ConfigurationUtils.createConfiguration((Properties)customConf));
        }
        return this.newRestClusterClient(configuration);
    }

    private RestClusterClient<StandaloneClusterId> newRestClusterClient(Configuration configuration) throws Exception {
        return new RestClusterClient(configuration, (Object)StandaloneClusterId.getInstance());
    }

    private static List<URL> toURLs(String classpaths) throws MalformedURLException {
        if (classpaths == null || "".equals(classpaths.trim())) {
            return Collections.emptyList();
        }
        String[] paths = classpaths.contains(";") ? classpaths.split(";") : classpaths.split(",");
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < paths.length; ++i) {
            urls.add(new URL(paths[i].trim()));
        }
        return urls;
    }

    private static Properties toProperties(String configuration) throws IOException {
        Properties properties = null;
        if (configuration != null) {
            properties = new Properties();
            properties.load(new StringReader(configuration));
        }
        return properties;
    }

    static {
        localOperates = Sets.as("Bsh", "Jdbc");
        Configuration configuration = ConfigurationUtils.createConfiguration((Properties)FlinkJobsClientsContext.getConfigProperties());
        String rpcServers = FlinkJobsClientsContext.getProperty("jobmanager.rpc.servers");
        if (StringUtils.isBlank((CharSequence)rpcServers)) {
            configurations.add(configuration);
        } else {
            String[] servers = rpcServers.split(",");
            for (int i = 0; i < servers.length; ++i) {
                Configuration config = configuration.clone();
                String[] server = servers[i].split(":", 2);
                config.set(JobManagerOptions.ADDRESS, (Object)server[0].trim());
                if (server.length > 1) {
                    config.set(JobManagerOptions.PORT, (Object)Integer.parseInt(server[1].trim()));
                } else if (!config.contains(JobManagerOptions.PORT)) {
                    config.set(JobManagerOptions.PORT, (Object)6123);
                }
                configurations.add(config);
            }
        }
        COUNT = configurations.size();
    }

    private static interface Actuator<T> {
        public T execute(RestClusterClient<StandaloneClusterId> var1) throws Exception;
    }
}

