/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.flink.jobs.clients;

import cn.tenmg.flink.jobs.FlinkJobsClient;
import cn.tenmg.flink.jobs.clients.context.FlinkJobsClientsContext;
import cn.tenmg.flink.jobs.clients.utils.Sets;
import cn.tenmg.flink.jobs.config.model.FlinkJobs;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Set;

public abstract class AbstractFlinkJobsClient<T>
implements FlinkJobsClient<T> {
    private static final String FLINK_JOBS_DEFAULT_JAR_KEY = "flink.jobs.default.jar";
    private static final String FLINK_JOBS_DEFAULT_CLASS_KEY = "flink.jobs.default.class";
    private static final String JAR = ".jar";
    private static final Set<String> EXCLUDES = Sets.as("options", "mainClass", "jar", "allwaysNewJob");
    protected static final String EMPTY_ARGUMENTS = "{}";

    protected static String getJar(FlinkJobs flinkJobs) {
        String jar = flinkJobs.getJar();
        if (jar == null) {
            jar = FlinkJobsClientsContext.getProperty(FLINK_JOBS_DEFAULT_JAR_KEY);
        }
        if (jar == null) {
            throw new IllegalArgumentException("You must specify the jar to run or configurate by key flink.jobs.default.jar in " + FlinkJobsClientsContext.getConfigLocation());
        }
        return jar;
    }

    protected static int validateJar(String jar) {
        int jarIndex = jar.lastIndexOf(JAR);
        if (jarIndex <= 0) {
            throw new IllegalArgumentException("The jar file configuration must end with .jar suffix");
        }
        return jarIndex;
    }

    protected static String getEntryPointClassName(FlinkJobs flinkJobs) {
        String mainClass = flinkJobs.getMainClass();
        if (mainClass == null) {
            mainClass = FlinkJobsClientsContext.getProperty(FLINK_JOBS_DEFAULT_CLASS_KEY);
        }
        return mainClass;
    }

    protected static String getArguments(FlinkJobs flinkJobs) {
        return JSON.toJSONString((Object)flinkJobs, (SerializeFilter)new PropertyFilter(){

            public boolean apply(Object object, String name, Object value) {
                return !EXCLUDES.contains(name);
            }
        }, (SerializerFeature[])new SerializerFeature[0]);
    }

    protected static Boolean isEmptyArguments(String arguments) {
        return arguments == null || EMPTY_ARGUMENTS.equals(arguments) || "".equals(arguments.trim());
    }
}

