/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.cdc.log.connectors.postgres.table;

import cn.tenmg.cdc.log.connectors.postgres.table.PostgreSQLTableSource;
import cn.tenmg.cdc.log.debezium.table.DebeziumOptions;
import cn.tenmg.cdc.log.debezium.utils.ResolvedSchemaUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class PostgreSQLTableFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "postgres-cdc-log";
    private static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the PostgreSQL database server.");
    private static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)5432).withDescription("Integer port number of the PostgreSQL database server.");
    private static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the PostgreSQL database to use when connecting to the PostgreSQL database server.");
    private static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the PostgreSQL database server.");
    private static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the PostgreSQL server to monitor.");
    private static final ConfigOption<String> SCHEMA_NAME = ConfigOptions.key((String)"schema-name").stringType().noDefaultValue().withDescription("Schema name of the PostgreSQL database to monitor.");
    private static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the PostgreSQL database to monitor.");
    private static final ConfigOption<String> DECODING_PLUGIN_NAME = ConfigOptions.key((String)"decoding.plugin.name").stringType().defaultValue((Object)"decoderbufs").withDescription("The name of the Postgres logical decoding plug-in installed on the server.\nSupported values are decoderbufs, wal2json, wal2json_rds, wal2json_streaming,\nwal2json_rds_streaming and pgoutput.");
    private static final ConfigOption<String> SLOT_NAME = ConfigOptions.key((String)"slot.name").stringType().defaultValue((Object)"flink").withDescription("The name of the PostgreSQL logical decoding slot that was created for streaming changes from a particular plug-in for a particular database/schema. The server uses this slot to stream events to the connector that you are configuring. Default is \"flink\".");

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium."});
        ReadableConfig config = helper.getOptions();
        String hostname = (String)config.get(HOSTNAME);
        String username = (String)config.get(USERNAME);
        String password = (String)config.get(PASSWORD);
        String databaseName = (String)config.get(DATABASE_NAME);
        String schemaName = (String)config.get(SCHEMA_NAME);
        String tableName = (String)config.get(TABLE_NAME);
        int port = (Integer)config.get(PORT);
        String pluginName = (String)config.get(DECODING_PLUGIN_NAME);
        String slotName = (String)config.get(SLOT_NAME);
        ResolvedSchema physicalSchema = ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)context.getCatalogTable().getResolvedSchema());
        return new PostgreSQLTableSource(physicalSchema, port, hostname, databaseName, schemaName, tableName, username, password, pluginName, slotName, DebeziumOptions.getDebeziumProperties((Map)context.getCatalogTable().getOptions()));
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(HOSTNAME);
        options.add(USERNAME);
        options.add(PASSWORD);
        options.add(DATABASE_NAME);
        options.add(SCHEMA_NAME);
        options.add(TABLE_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PORT);
        options.add(DECODING_PLUGIN_NAME);
        options.add(SLOT_NAME);
        return options;
    }
}

