/*
 * Decompiled with CFR 0.152.
 */
package cn.tenmg.cdc.log.connectors.postgres.table;

import cn.tenmg.cdc.log.debezium.table.MetadataConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public enum PostgreSQLReadableMetadata {
    TABLE_NAME("table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("table"));
        }
    }),
    SCHEMA_NAME("schema_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("schema"));
        }
    }),
    DATABASE_NAME("database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return StringData.fromString((String)sourceStruct.getString("db"));
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)sourceStruct.get("ts_ms")));
        }
    });

    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;

    private PostgreSQLReadableMetadata(String key, DataType dataType, MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }
}

